#
# TABLE STRUCTURE FOR: acceso
#

DROP TABLE IF EXISTS `acceso`;

CREATE TABLE `acceso` (
  `acceso_id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_acceso` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`acceso_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `acceso` (`acceso_id`, `nombre_acceso`) VALUES ('1', 'GERENCIA');
INSERT INTO `acceso` (`acceso_id`, `nombre_acceso`) VALUES ('2', 'RECEPCION');


#
# TABLE STRUCTURE FOR: certificados
#

DROP TABLE IF EXISTS `certificados`;

CREATE TABLE `certificados` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `codigo` varchar(20) NOT NULL,
  `analisis` varchar(100) NOT NULL,
  `n_certificado` varchar(10) NOT NULL,
  `pertenencia` varchar(100) NOT NULL,
  `lote` varchar(20) NOT NULL,
  `procedencia` varchar(100) NOT NULL,
  `observacion` varchar(200) NOT NULL,
  `mineral` varchar(200) NOT NULL,
  `fecha` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34791 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33479', '0CM-200', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33480', '709JC-SK-30', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33481', '0MAX-304', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33482', '700RJ.300', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33483', '700RJ.301', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33484', '7051895-23', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33485', '702RD-520', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33486', '702RD-522', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33487', '704CC-606-23-R', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33488', '708M.E. 20-02', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33489', '0L:707', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33490', '0MUESTRA ESPECIAL ', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33491', '712M.E.-8', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33492', '712M.E.-7', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33493', '712M.E.-6', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33494', '703SV-129', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33495', '703SV-127', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33496', '703SV-128', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33497', '6991036', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33498', '6991037', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33499', '6991035', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33500', '7011650', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', 'SAN JUAN \"J.A.M.\"', '', 'ESTAÑO 34.53 % Sn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33501', '71MRB-2294', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33502', '718A-ZNA-23011', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33503', '720CS-366', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', 'MULTISERVICIOS \"SJ\"', '', 'ZINC 7.35 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33504', '0CS-367', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', 'MULTISERVICIOS \"SJ\"', '', 'ZINC 6.45 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33505', '720CS-368', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', 'MULTISERVICIOS \"SJ\"', '', 'ZINC 6.31 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33506', '727C23-01-86', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33507', '728C23-01-88', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33508', '710MUESTRA ESPECIAL ', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33509', '7242090', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33510', '719LM-2181', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33511', '386LM-2176', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33512', '726LM-2184', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33513', '717B.C. 0.36', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33514', '717B.C.035', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33515', '47LM-2178', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33516', '74LM-2179', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33517', '708M.E. 20-01', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33518', '711L-011-KL23', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33519', '0L:710', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33520', '0L:708', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33521', '0L:709', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33522', '715SV-131', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33523', '7141488', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33524', '7141487', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33525', '722082', ' - PLATA', '1221', 'JHOJAN ANTONY ', '082', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33526', '715SV-132', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33527', '7373', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33528', '0E-00153', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33529', '736MUESTRA ESPECIAL ', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33530', '7232060', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33531', '725EZN-172', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33532', '722083', ' - PLATA', '1228', 'JHOJAN ANTONY ', '083', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33533', '7232058', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33534', '7232059', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33535', '7232057', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33536', '3910359', ' - PLATA', '1232', 'GONZALO SALVATIERA', '0359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33537', '3910360', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '0360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33538', '347R-17', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33539', '73305', ' - PLATA', '1235', 'TEOFILO QUIROGA', '05', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33540', '023L03575', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33541', '388MUESTRA ESPECIAL', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33542', '73123L03554', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33543', '73301', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '01', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33544', '7290357', ' - PLATA - PLOMO', '1240', 'CARLOS CHOQUE', '0357', 'R-METALS', '', 'PLATA 16.06 DM Ag|PLOMO 19.15 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33545', '98ID-063/23', ' - ZINC - PLATA - PLOMO - HUMEDAD', '1241', 'IVO DELGADO', 'ID-063/23', 'S/P', '', 'ZINC 12.89 % Zn|PLATA 5.70 DM Ag|PLOMO 26.88 % Pb|HUMEDAD 9.20 % H2O|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33546', '98ID-081/23', ' - ZINC - PLATA - HUMEDAD', '1242', 'IVO DELGADO', 'ID-081/23', 'S/P', '', 'ZINC 44.75 % Zn|PLATA 2.55 DM Ag|HUMEDAD 9.28 % H2O|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33547', '14841489', ' - PLATA', '1243', 'MIGUEL MANCILLA', '1489', 'ESTIRPE DE PLATA', '', 'PLATA 496.59 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33548', '734MUESTRA ESPECIAL ', ' - ZINC - PLATA - PLOMO', '1244', 'RICARDO QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 5.50 % Zn|PLATA 1.76 DM Ag|PLOMO 2.10 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33549', '745VAL3-316', ' - ZINC - PLATA', '1245', 'JOSE MIGUEL RAMOS', 'VAL3-316', 'MISERICORDIA S.R.L.', '', 'ZINC 15.25 % Zn|PLATA 0.86 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33550', '744VAL3-318', ' - ZINC - PLATA', '1246', 'BEYMAR SUARES', 'VAL3-318', 'MISERICORDIA S.R.L.', '', 'ZINC 9.03 % Zn|PLATA 1.32 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33551', '0MUESTRA ESPECIAL ', ' - PLATA - PLOMO', '1247', 'RAUL IBARRA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 11.30 DM Ag|PLOMO 52.39 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33552', '74223L03613', ' - ZINC', '1248', 'LAMBOL MINA CONDOR ', '23L03613', 'LAMBOL S.A.', '', 'ZINC 5.55 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33553', '74029', ' - ZINC', '1249', 'CELSO SOLIZ', '29', 'RIO DE PLATA', '', 'ZINC 9.78 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33554', '74062', ' - ZINC', '1250', 'IGOR GOMEZ', '62', 'RIO DE PLATA', '', 'ZINC 6.88 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33555', '74650', ' - ZINC', '1251', 'CELSO SOLIZ', '50', 'RIO DE PLATA', '', 'ZINC 11.41 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33556', '7515158', ' - ZINC - PLATA - PLOMO', '1252', 'EULOGIO ARICOMA', '5158', 'ALDEEXPORMIN', '', 'ZINC 23.89 % Zn|PLATA 8.08 DM Ag|PLOMO 10.30 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33557', '7515156', ' - ZINC - PLATA - PLOMO', '1253', 'GONZALO HUARACHI', '5156', 'ALDEEXPORMIN', '', 'ZINC 26.06 % Zn|PLATA 8.60 DM Ag|PLOMO 6.40 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33558', '744CC-0602-23-R', ' - ZINC - PLATA - PLOMO', '1254', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0602-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.89 % Zn|PLATA 4.40 DM Ag|PLOMO 5.55 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33559', '749CC-0611-23-R', ' - ZINC - PLATA - PLOMO', '1255', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0611-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 4.77 % Zn|PLATA 3.46 DM Ag|PLOMO 7.40 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33560', '744CC-0613-23-R', ' - ZINC - PLATA - PLOMO', '1256', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0613-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.19 % Zn|PLATA 4.70 DM Ag|PLOMO 5.15 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33561', '82COLA', ' - ZINC', '1257', 'OSCAR VILLCA', 'COLA', 'S/P', '', 'ZINC 0.68 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33562', '82CONCENTRADO', ' - PLATA', '1258', 'OSCAR VILLCA', 'CONCENTRADO', 'S/P', '', 'PLATA 60.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33563', '0MMNEE', ' - PLATA', '1259', 'MINEXA S.R.L. ', 'MMNEE', 'MINEXA S.R.L.', '', 'PLATA 583.88 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33564', '746SV-135', ' - PLATA', '1260', 'RENE TAPIA', 'SV-135', 'VETILLAS SRL.', '', 'PLATA 22.84 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33565', '756757', ' - PLATA', '1261', 'JHON FLORES', '757', 'FENIX', '', 'PLATA 260.55 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33566', '756758', ' - PLATA', '1262', 'JHON FLORES', '758', 'FENIX', '', 'PLATA 771.11 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33567', '75564', ' - PLATA', '1263', 'JUAN ISLA', '64', 'EL MAJESTUOSO', '', 'PLATA 22.84 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33568', '022033', ' - PLATA', '1264', 'RICHAR CUPARA', '22033', 'MINEXA S.R.L.', '', 'PLATA 585.50 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33569', '747DRC-16', ' - PLATA', '1265', 'LUIS DELGADO', 'DRC-16', 'ANGELES', '', 'PLATA 249.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33570', '7433876', ' - PLATA', '1266', 'CELSO CRUZ GUTIERREZ', '3876', 'UNIFICADA POTOSI R.L.', '', 'PLATA 12.46 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33571', '7486910', ' - PLATA', '1267', 'CARLOS FLORES', '6910', 'COEXMIN S.R.L.', '', 'PLATA 240.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33572', '7605693', ' - PLATA', '1268', 'SINFORIANO PUMA', '5693', 'EMCON S.R.L.', '', 'PLATA 56.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33573', '7643090', ' - PLATA', '1269', 'ABELIÑO GUTIERREZ', '3090', 'CKACHAS S.R.L.', '', 'PLATA 205.17 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33574', '7643095', ' - PLATA', '1270', 'ABELINO GUTIERREZ', '3095', 'CKACHAS S.R.L.', '', 'PLATA 365.18 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33575', '7391653', ' - ESTAÑO', '1271', 'JORGE FERNANDEZ', '1653', 'SAN JUAN J.A.M.', '', 'ESTAÑO 22.39 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33576', '77201-TACURI', ' - PLATA', '1272', 'JUAN TACURI', '01-TACURI', 'FENIX', '', 'PLATA 4.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33577', '757012', ' - ZINC - PLATA', '1273', 'WILSON O.', '012', 'S/P', '', 'ZINC 12.05 % Zn|PLATA 1.80 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33578', '757011', ' - ZINC - PLATA', '1274', 'WILSON O.', '011', 'S/P', '', 'ZINC 13.56 % Zn|PLATA 2.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33579', '763CC-2502', ' - PLATA', '1275', 'CRISTIAN CALDERON', 'CC-2502', 'S/P', '', 'PLATA 2.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33580', '754LM-2191', ' - ZINC', '1276', 'ESEGUIEL RUIZ', 'LM-2191', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.05 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33581', '773LM-2170', ' - ZINC - PLATA - PLOMO', '1277', 'COOP. HUAYNA PORCO', 'LM-2170', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.89 % Zn|PLATA 2.30 DM Ag|PLOMO 7.70 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33582', '0MUESTRA ESPECIAL', ' - ZINC - PLATA', '1278', 'WALTER RAMOS', 'MUESTRA ESPECIAL', 'S/P', '', 'ZINC 20.21 % Zn|PLATA 1.65 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33583', '761MUESTRA ESPECIAL ', ' - ZINC - PLATA', '1279', 'ROLANDO COPA', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 51.89 % Zn|PLATA 2.03 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33584', '769SPA-AG-40', ' - PLATA', '1280', 'JORGE CRUZ', 'SPA-AG-40', 'SINCHI PUKARA S.R.L.', '', 'PLATA 3.85 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33585', '7591907-23', ' - ZINC', '1281', 'LEANDRO SUYO', '1907-23', 'IMSUR', '', 'ZINC 2.50 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33586', '758PBX1', ' - PLATA', '1282', 'JHONNY MAMANI', 'PBX1', 'FENIX', '', 'PLATA 8.65 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33587', '002-R', ' - PLATA', '1283', 'JHONY MAMANI', '02-R', 'FENIX', '', 'PLATA 1.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33588', '752C-10287', ' - ZINC - PLATA - PLOMO', '1284', 'PLACIDO COPA MARTINEZ', 'C-10287', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 5.70 % Zn|PLATA 1.40 DM Ag|PLOMO 0.45 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33589', '769C-10291', ' - ZINC', '1285', 'GONZALO LIMACHI', 'C-10291', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 8.55 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33590', '753C-10289', ' - ZINC - PLATA', '1286', 'ALVARO SAAVEDRA', 'C-10289', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 4.10 % Zn|PLATA 1.85 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33591', '766C-0161', ' - PLATA', '1287', 'LUIS CRUZ', 'C-0161', 'REDMETALS R.R.L.', '', 'PLATA 3.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33592', '766C-0160', ' - PLATA', '1288', 'LUIS CRUZ', 'C-0160', 'REDMETALS R.R.L.', '', 'PLATA 3.35 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33593', '753C-10288', ' - ZINC - PLATA', '1289', 'ALVARO SAAVEDRA', 'C-10288', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 3.30 % Zn|PLATA 1.66 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33594', '76905', ' - PLATA', '1290', 'JORGE CRUZ', '05', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 4.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33595', '777M-109', ' - PLATA', '1291', 'ALEXANDER CHIPANA', 'M-109', 'CAMPO VERDE', '', 'PLATA 3.20 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33596', '0LM-2189', ' - ZINC', '1292', 'FLORENCIO CONDORI', 'LM-2189', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 11.58 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33597', '779MRB-2122', ' - ZINC - PLATA', '1293', 'JORGE LUIS COPACABA CRUZ', 'MRB-2122', 'RODRIGUEZJM S.R.L.', '', 'ZINC 18.88 % Zn|PLATA 8.45 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33598', '38LM-2201', ' - ZINC', '1294', 'DAVID ALVAREZ', 'LM-2201', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 12.05 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33599', '781CV-730', ' - ZINC - PLATA', '1295', 'CIRILO LUNASCO CANSECO', 'CV-730', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 19.60 % Zn|PLATA 1.07 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33600', '782CV-732', ' - ZINC - PLATA', '1296', 'CIRILO LUNASCO CANSECO', 'CV-732', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 25.41 % Zn|PLATA 1.11 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33601', '781CV-726', ' - ZINC - PLATA', '1297', 'CIRILO LUNASCO CANSECO', 'CV-726', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 21.89 % Zn|PLATA 1.05 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33602', '38LM-2202', ' - ZINC', '1298', 'DAVID ALVAREZ', 'LM-2202', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.12 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33603', '780CV-734', ' - ZINC - PLATA', '1299', 'CIRILO LUNASCO CANSECO', 'CV-734', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 18.67 % Zn|PLATA 1.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33604', '782CV-731', ' - ZINC - PLATA', '1300', 'CIRILO LUNASCO CANSECO', 'CV-731', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 27.18 % Zn|PLATA 1.13 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33605', '781CV-728', ' - ZINC - PLATA', '1301', 'CIRILO LUNASCO CANSECO', 'CV-728', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 20.04 % Zn|PLATA 0.89 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33606', '780CV-727', ' - ZINC - PLATA', '1302', 'CIRILO LUNASCO CANSECO', 'CV-727', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 29.14 % Zn|PLATA 1.31 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33607', '778CC-0626/23', ' - ZINC - PLATA', '1303', 'SERAPIO PORTILLO SERRANO', 'CC-0626/23', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.70 % Zn|PLATA 1.08 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33608', '0MUESTRA ESPECIAL -1', ' - ESTAÑO', '1304', 'C.T.S. ', 'MUESTRA ESPECIAL -1', 'S/P', '', 'ESTAÑO 1.04 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33609', '0MUESTRA ESPECIAL -2', ' - ESTAÑO', '1305', 'C.T.S. ', 'MUESTRA ESPECIAL -2', 'S/P', '', 'ESTAÑO 0.41 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33610', '701FM-13/23', ' - ZINC - PLATA - HUMEDAD', '1306', 'GREGORIO CHOQUE', 'FM-13/23', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 33.58 % Zn|PLATA 6.11 DM Ag|HUMEDAD 8.89 % H2O|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33611', '773L-AG/0396', ' - PLATA', '1307', 'TEODORO RAMIREZ', 'L-AG/0396', 'ISMAR S.R.L.', '', 'PLATA 134.68 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33612', '398MUESTRA ESPECIAL ', ' - PLATA - PLOMO', '1308', 'NELSON CALLA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|PLOMO 30.11 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33613', '770SV-137', ' - PLATA', '1309', 'JANNETH IGLESIAS', 'SV-137', 'VETILLAS SRL.', '', 'PLATA 245.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33614', '701001', ' - PLATA - HUMEDAD', '1310', 'GREGORIO CHOQUE', '001', 'VIRGEN DE COTOCA S.R.L.', '', 'PLATA 33.64 DM Ag|HUMEDAD 7.90 % H2O|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33615', '7745695', ' - PLATA', '1311', 'ALBERTO GALLARDO', '5695', 'EMCON S.R.L.', '', 'PLATA 120.17 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33616', '7711580', ' - PLATA', '1312', 'GREGORIO CHOQUE', '1580', 'PUENTE DE PLATA S.R.L.', '', 'PLATA 44.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33617', '795KNFG-1515', ' - ZINC - PLATA - PLOMO', '1313', 'EPIFANIO CRUZ G.', 'KNFG-1515', 'KERUMIN S.R.L.', '', 'ZINC 12.00 % Zn|PLATA 3.00 DM Ag|PLOMO 4.00 % Pb|', '2023-02-07');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33618', 'L-000123', 'ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '-', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33619', 'L-000124', 'ZINC', '1177', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33620', 'L-5000', '- PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33621', 'L-1', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33622', 'L-2', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33623', 'L-3', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33624', 'L-4', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33625', 'L-5', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33626', 'L-6', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33627', 'L-7', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33628', 'L-8', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33629', 'L-9', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33630', 'L-10', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33631', 'L-11', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33632', 'L-12', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33633', 'L-13', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33634', 'L-14', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33635', '0.00E+00', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33636', 'LI-200', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33637', 'LI-201', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33638', 'LI-202', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33639', 'LI-203', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33640', 'LI-204', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33641', 'LI-205', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33642', 'LI-206', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33643', 'LI-207', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33644', 'LI-208', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33645', 'LI-209', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33646', 'LI-210', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33647', 'LI-211', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33648', 'LI-212', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33649', 'LI-213', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33650', 'LI-214', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33651', 'LI-215', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33652', 'LI-216', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33653', 'LI-217', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33654', 'LI-218', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33655', 'LI-219', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33656', 'LI-220', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33657', 'LI-221', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33658', 'LI-222', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33659', 'LI-223', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33660', 'LI-224', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33661', 'LI-225', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33662', 'LI-226', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33663', 'LI-227', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33664', 'LI-228', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33665', 'LI-229', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33666', 'LI-230', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33667', 'LI-231', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33668', 'LI-232', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33669', 'LI-233', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33670', 'LI-234', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33671', 'LI-235', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33672', 'LI-236', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33673', 'LI-237', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33674', 'LI-238', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33675', 'LI-239', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33676', 'LI-240', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33677', 'LI-241', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33678', 'LI-242', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33679', 'LI-243', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33680', 'LI-244', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33681', 'LI-245', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33682', 'LI-246', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33683', 'LI-247', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33684', 'LI-248', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33685', 'LI-249', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33686', 'LI-250', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33687', 'LI-251', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33688', 'LI-252', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33689', 'LI-253', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33690', 'LI-254', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33691', 'LI-255', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33692', 'LI-256', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33693', 'LI-257', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33694', 'LI-258', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33695', 'LI-259', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33696', 'LI-260', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33697', 'LI-261', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33698', 'LI-262', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33699', 'LI-263', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33700', 'LI-264', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33701', 'LI-265', ' - PLATA - PLOMO', '1240', 'CARLOS CHOQUE', '357', 'R-METALS', '', 'PLATA 16.06 DM Ag|PLOMO 19.15 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33702', 'LI-266', ' - ZINC - PLATA - PLOMO - HUMEDAD', '1241', 'IVO DELGADO', 'ID-063/23', 'S/P', '', 'ZINC 12.89 % Zn|PLATA 5.70 DM Ag|PLOMO 26.88 % Pb|HUMEDAD 9.20 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33703', 'LI-267', ' - ZINC - PLATA - HUMEDAD', '1242', 'IVO DELGADO', 'ID-081/23', 'S/P', '', 'ZINC 44.75 % Zn|PLATA 2.55 DM Ag|HUMEDAD 9.28 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33704', 'LI-268', '#?NOMBRE?', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33705', 'C-100', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33706', 'C-101', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33707', 'C-102', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33708', 'C-103', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33709', 'C-104', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33710', 'C-105', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33711', 'C-106', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33712', 'C-107', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33713', 'C-108', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33714', 'C-109', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33715', 'C-110', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33716', 'C-111', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33717', 'C-112', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33718', 'C-113', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33719', 'C-114', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33720', 'C-115', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33721', 'C-116', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33722', 'C-117', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33723', 'C-118', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33724', 'C-119', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33725', 'C-120', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33726', 'C-121', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33727', 'C-122', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33728', 'C-123', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33729', 'C-124', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33730', 'C-125', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33731', 'C-126', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33732', 'C-127', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33733', 'C-128', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33734', 'C-129', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33735', 'C-130', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33736', 'C-131', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33737', 'C-132', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33738', 'C-133', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33739', 'C-134', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33740', 'C-135', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33741', 'C-136', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33742', 'C-137', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33743', 'C-138', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33744', 'C-139', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33745', 'C-140', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33746', 'C-141', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33747', 'C-142', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33748', 'C-143', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33749', 'C-144', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33750', 'C-145', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33751', 'C-146', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33752', 'C-147', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33753', 'C-148', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33754', 'C-149', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33755', 'C-150', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33756', 'C-151', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33757', 'C-152', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33758', 'C-153', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33759', 'C-154', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33760', 'C-155', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33761', 'C-156', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33762', 'C-157', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33763', 'C-158', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33764', 'C-159', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33765', 'C-160', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33766', 'C-161', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33767', 'C-162', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33768', 'C-163', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33769', 'C-164', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33770', 'C-1000', ' - PLATA', '1243', 'MIGUEL MANCILLA', '1489', 'ESTIRPE DE PLATA', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33771', 'C-1001', ' - ZINC - PLATA - PLOMO', '1244', 'RICARDO QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 5.50 % Zn|PLATA 1.76 DM Ag|PLOMO 2.10 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33772', 'C-1002', ' - ZINC - PLATA', '1245', 'JOSE MIGUEL RAMOS', 'VAL3-316', 'MISERICORDIA S.R.L.', '', 'ZINC 15.25 % Zn|PLATA 0.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33773', 'C-1003', ' - ZINC - PLATA', '1246', 'BEYMAR SUARES', 'VAL3-318', 'MISERICORDIA S.R.L.', '', 'ZINC 9.03 % Zn|PLATA 1.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33774', 'C-1004', ' - PLATA - PLOMO', '1247', 'RAUL IBARRA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 11.30 DM Ag|PLOMO 52.39 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33775', 'C-1005', ' - ZINC', '1248', 'LAMBOL MINA CONDOR ', '23L03613', 'LAMBOL S.A.', '', 'ZINC 5.55 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33776', 'C-1006', ' - ZINC', '1249', 'CELSO SOLIZ', '29', 'RIO DE PLATA', '', 'ZINC 9.78 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33777', 'C-1007', ' - ZINC', '1250', 'IGOR GOMEZ', '62', 'RIO DE PLATA', '', 'ZINC 6.88 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33778', 'C-1008', ' - ZINC', '1251', 'CELSO SOLIZ', '50', 'RIO DE PLATA', '', 'ZINC 11.41 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33779', 'C-1009', ' - ZINC - PLATA - PLOMO', '1252', 'EULOGIO ARICOMA', '5158', 'ALDEEXPORMIN', '', 'ZINC 23.89 % Zn|PLATA 8.08 DM Ag|PLOMO 10.30 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33780', 'C-1010', ' - ZINC - PLATA - PLOMO', '1253', 'GONZALO HUARACHI', '5156', 'ALDEEXPORMIN', '', 'ZINC 26.06 % Zn|PLATA 8.60 DM Ag|PLOMO 6.40 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33781', 'C-1011', ' - ZINC - PLATA - PLOMO', '1254', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0602-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.89 % Zn|PLATA 4.40 DM Ag|PLOMO 5.55 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33782', 'C-1012', ' - ZINC - PLATA - PLOMO', '1255', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0611-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 4.77 % Zn|PLATA 3.46 DM Ag|PLOMO 7.40 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33783', 'C-1013', ' - ZINC - PLATA - PLOMO', '1256', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0613-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.19 % Zn|PLATA 4.70 DM Ag|PLOMO 5.15 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33784', 'C-1014', ' - ZINC', '1257', 'OSCAR VILLCA', 'COLA', 'S/P', '', 'ZINC 0.68 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33785', 'C-1015', ' - PLATA', '1258', 'OSCAR VILLCA', 'CONCENTRADO', 'S/P', '', 'PLATA 60.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33786', 'C-1016', ' - PLATA', '1259', 'MINEXA S.R.L. ', 'MMNEE', 'MINEXA S.R.L.', '', 'PLATA 583.88 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33787', 'C-1017', ' - PLATA', '1260', 'RENE TAPIA', 'SV-135', 'VETILLAS SRL.', '', 'PLATA 22.84 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33788', 'C-1018', ' - PLATA', '1261', 'JHON FLORES', '757', 'FENIX', '', 'PLATA 260.55 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33789', 'C-1019', ' - PLATA', '1262', 'JHON FLORES', '758', 'FENIX', '', 'PLATA 771.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33790', 'C-1020', ' - PLATA', '1263', 'JUAN ISLA', '64', 'EL MAJESTUOSO', '', 'PLATA 22.84 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33791', 'C-1021', ' - PLATA', '1264', 'RICHAR CUPARA', '22033', 'MINEXA S.R.L.', '', 'PLATA 585.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33792', 'C-1022', ' - PLATA', '1265', 'LUIS DELGADO', 'DRC-16', 'ANGELES', '', 'PLATA 249.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33793', 'C-1023', ' - PLATA', '1266', 'CELSO CRUZ GUTIERREZ', '3876', 'UNIFICADA POTOSI R.L.', '', 'PLATA 12.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33794', 'C-1024', ' - PLATA', '1267', 'CARLOS FLORES', '6910', 'COEXMIN S.R.L.', '', 'PLATA 240.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33795', 'C-1025', ' - PLATA', '1268', 'SINFORIANO PUMA', '5693', 'EMCON S.R.L.', '', 'PLATA 56.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33796', 'C-1026', ' - PLATA', '1269', 'ABELIÑO GUTIERREZ', '3090', 'CKACHAS S.R.L.', '', 'PLATA 205.17 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33797', 'C-1027', ' - PLATA', '1270', 'ABELINO GUTIERREZ', '3095', 'CKACHAS S.R.L.', '', 'PLATA 365.18 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33798', 'C-1028', ' - ESTAÑO', '1271', 'JORGE FERNANDEZ', '1653', 'SAN JUAN J.A.M.', '', 'ESTAÑO 22.39 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33799', 'C-1029', ' - PLATA', '1272', 'JUAN TACURI', '01-TACURI', 'FENIX', '', 'PLATA 4.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33800', 'C-1030', ' - ZINC - PLATA', '1273', 'WILSON O.', '12', 'S/P', '', 'ZINC 12.05 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33801', 'C-1031', ' - ZINC - PLATA', '1274', 'WILSON O.', '11', 'S/P', '', 'ZINC 13.56 % Zn|PLATA 2.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33802', 'C-1032', ' - PLATA', '1275', 'CRISTIAN CALDERON', 'CC-2502', 'S/P', '', 'PLATA 2.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33803', 'C-1033', ' - ZINC', '1276', 'ESEGUIEL RUIZ', 'LM-2191', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.05 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33804', 'C-1034', ' - ZINC - PLATA - PLOMO', '1277', 'COOP. HUAYNA PORCO', 'LM-2170', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.89 % Zn|PLATA 2.30 DM Ag|PLOMO 7.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33805', 'C-1035', ' - ZINC - PLATA', '1278', 'WALTER RAMOS', 'MUESTRA ESPECIAL', 'S/P', '', 'ZINC 20.21 % Zn|PLATA 1.65 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33806', 'C-1036', ' - ZINC - PLATA', '1279', 'ROLANDO COPA', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 51.89 % Zn|PLATA 2.03 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33807', 'C-1037', ' - PLATA', '1280', 'JORGE CRUZ', 'SPA-AG-40', 'SINCHI PUKARA S.R.L.', '', 'PLATA 3.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33808', 'C-1038', ' - ZINC', '1281', 'LEANDRO SUYO', '1907-23', 'IMSUR', '', 'ZINC 2.50 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33809', 'C-1039', ' - PLATA', '1282', 'JHONNY MAMANI', 'PBX1', 'FENIX', '', 'PLATA 8.65 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33810', 'C-1040', ' - PLATA', '1283', 'JHONY MAMANI', '02-R', 'FENIX', '', 'PLATA 1.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33811', 'C-1041', ' - ZINC - PLATA - PLOMO', '1284', 'PLACIDO COPA MARTINEZ', 'C-10287', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 5.70 % Zn|PLATA 1.40 DM Ag|PLOMO 0.45 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33812', 'C-1042', ' - ZINC', '1285', 'GONZALO LIMACHI', 'C-10291', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 8.55 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33813', 'C-1043', ' - ZINC - PLATA', '1286', 'ALVARO SAAVEDRA', 'C-10289', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 4.10 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33814', 'C-1044', ' - PLATA', '1287', 'LUIS CRUZ', 'C-0161', 'REDMETALS R.R.L.', '', 'PLATA 3.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33815', 'C-1045', ' - PLATA', '1288', 'LUIS CRUZ', 'C-0160', 'REDMETALS R.R.L.', '', 'PLATA 3.35 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33816', 'C-1046', ' - ZINC - PLATA', '1289', 'ALVARO SAAVEDRA', 'C-10288', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 3.30 % Zn|PLATA 1.66 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33817', 'C-1047', ' - PLATA', '1290', 'JORGE CRUZ', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 4.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33818', 'C-1048', ' - PLATA', '1291', 'ALEXANDER CHIPANA', 'M-109', 'CAMPO VERDE', '', 'PLATA 3.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33819', 'C-1049', ' - ZINC', '1292', 'FLORENCIO CONDORI', 'LM-2189', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 11.58 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33820', 'C-1050', ' - ZINC - PLATA', '1293', 'JORGE LUIS COPACABA CRUZ', 'MRB-2122', 'RODRIGUEZJM S.R.L.', '', 'ZINC 18.88 % Zn|PLATA 8.45 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33821', 'C-1051', ' - ZINC', '1294', 'DAVID ALVAREZ', 'LM-2201', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 12.05 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33822', 'C-1052', ' - ZINC - PLATA', '1295', 'CIRILO LUNASCO CANSECO', 'CV-730', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 19.60 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33823', 'C-1053', ' - ZINC - PLATA', '1296', 'CIRILO LUNASCO CANSECO', 'CV-732', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 25.41 % Zn|PLATA 1.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33824', 'C-1054', ' - ZINC - PLATA', '1297', 'CIRILO LUNASCO CANSECO', 'CV-726', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 21.89 % Zn|PLATA 1.05 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33825', 'C-1055', ' - ZINC', '1298', 'DAVID ALVAREZ', 'LM-2202', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.12 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33826', 'C-1056', ' - ZINC - PLATA', '1299', 'CIRILO LUNASCO CANSECO', 'CV-734', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 18.67 % Zn|PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33827', 'C-1057', ' - ZINC - PLATA', '1300', 'CIRILO LUNASCO CANSECO', 'CV-731', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 27.18 % Zn|PLATA 1.13 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33828', 'C-1058', ' - ZINC - PLATA', '1301', 'CIRILO LUNASCO CANSECO', 'CV-728', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 20.04 % Zn|PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33829', 'C-1059', ' - ZINC - PLATA', '1302', 'CIRILO LUNASCO CANSECO', 'CV-727', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 29.14 % Zn|PLATA 1.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33830', 'C-1060', ' - ZINC - PLATA', '1303', 'SERAPIO PORTILLO SERRANO', 'CC-0626/23', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.70 % Zn|PLATA 1.08 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33831', 'C-1061', ' - ESTAÑO', '1304', 'C.T.S. ', 'MUESTRA ESPECIAL -1', 'S/P', '', 'ESTAÑO 1.04 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33832', 'C-1062', ' - ESTAÑO', '1305', 'C.T.S. ', 'MUESTRA ESPECIAL -2', 'S/P', '', 'ESTAÑO 0.41 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33833', 'C-1063', ' - ZINC - PLATA - HUMEDAD', '1306', 'GREGORIO CHOQUE', 'FM-13/23', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 33.58 % Zn|PLATA 6.11 DM Ag|HUMEDAD 8.89 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33834', 'C-1064', ' - PLATA', '1307', 'TEODORO RAMIREZ', 'L-AG/0396', 'ISMAR S.R.L.', '', 'PLATA 134.68 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33835', 'C-1065', ' - PLATA - PLOMO', '1308', 'NELSON CALLA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|PLOMO 30.11 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33836', 'C-1066', ' - PLATA', '1309', 'JANNETH IGLESIAS', 'SV-137', 'VETILLAS SRL.', '', 'PLATA 245.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33837', 'C-1067', ' - PLATA - HUMEDAD', '1310', 'GREGORIO CHOQUE', '1', 'VIRGEN DE COTOCA S.R.L.', '', 'PLATA 33.64 DM Ag|HUMEDAD 7.90 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33838', 'C-1068', ' - PLATA', '1311', 'ALBERTO GALLARDO', '5695', 'EMCON S.R.L.', '', 'PLATA 120.17 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33839', 'C-1069', ' - PLATA', '1312', 'GREGORIO CHOQUE', '1580', 'PUENTE DE PLATA S.R.L.', '', 'PLATA 44.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33840', 'C-2000', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33841', 'C-2001', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33842', 'C-2002', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33843', 'C-2003', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33844', 'C-2004', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33845', 'C-2005', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33846', 'C-2006', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33847', 'C-2007', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33848', 'C-2008', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33849', 'C-2009', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33850', 'C-2010', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33851', 'C-2011', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33852', 'C-2012', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33853', 'C-2013', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33854', 'C-2014', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33855', 'C-2015', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33856', 'C-2016', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33857', 'C-2017', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33858', 'C-2018', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33859', 'C-2019', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33860', 'C-2020', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33861', 'C-2021', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33862', 'C-2022', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33863', 'C-2023', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33864', 'C-2024', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33865', 'C-2025', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33866', 'C-2026', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33867', 'C-2027', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33868', 'C-2028', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33869', 'C-2029', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33870', 'C-2030', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33871', 'C-2031', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33872', 'C-2032', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33873', 'C-2033', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33874', 'C-2034', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33875', 'C-2035', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33876', 'C-2036', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33877', 'C-2037', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33878', 'C-2038', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33879', 'C-2039', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33880', 'C-2040', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33881', 'C-2041', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33882', 'C-2042', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33883', 'C-2043', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33884', 'C-2044', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33885', 'C-2045', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33886', 'C-2046', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33887', 'C-2047', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33888', 'C-2048', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33889', 'C-2049', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33890', 'C-2050', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33891', 'C-2051', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33892', 'C-2052', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33893', 'C-2053', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33894', 'C-2054', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33895', 'C-2055', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33896', 'C-2056', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33897', 'C-2057', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33898', 'C-2058', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33899', 'C-2059', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33900', 'C-2060', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33901', 'C-2061', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33902', 'C-2062', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33903', 'C-2063', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33904', 'C-2064', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33905', 'C-2065', ' - PLATA - PLOMO', '1240', 'CARLOS CHOQUE', '357', 'R-METALS', '', 'PLATA 16.06 DM Ag|PLOMO 19.15 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33906', 'C-2066', ' - ZINC - PLATA - PLOMO - HUMEDAD', '1241', 'IVO DELGADO', 'ID-063/23', 'S/P', '', 'ZINC 12.89 % Zn|PLATA 5.70 DM Ag|PLOMO 26.88 % Pb|HUMEDAD 9.20 % H2O|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33907', 'C-2067', ' - ZINC - PLATA - HUMEDAD', '1242', 'IVO DELGADO', 'ID-081/23', 'S/P', '', 'ZINC 44.75 % Zn|PLATA 2.55 DM Ag|HUMEDAD 9.28 % H2O|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33908', 'C-2068', '#?NOMBRE?', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33909', 'C-2069', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33910', 'C-2070', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33911', 'C-2071', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33912', 'C-2072', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33913', 'C-2073', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33914', 'C-2074', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33915', 'C-2075', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33916', 'C-2076', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33917', 'C-2077', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33918', 'C-2078', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33919', 'C-2079', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33920', 'C-2080', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33921', 'C-2081', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33922', 'C-2082', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33923', 'C-2083', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33924', 'C-2084', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33925', 'C-2085', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33926', 'C-2086', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33927', 'C-2087', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33928', 'C-2088', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33929', 'C-2089', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33930', 'C-2090', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33931', 'C-2091', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33932', 'C-2092', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33933', 'C-2093', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33934', 'C-2094', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33935', 'C-2095', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33936', 'C-2096', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33937', 'C-2097', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33938', 'C-2098', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33939', 'C-2099', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33940', 'C-2100', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33941', 'C-2101', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33942', 'C-2102', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33943', 'C-2103', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33944', 'C-2104', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33945', 'C-2105', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33946', 'C-2106', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33947', 'C-2107', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33948', 'C-2108', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33949', 'C-2109', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33950', 'C-2110', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33951', 'C-2111', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33952', 'C-2112', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33953', 'C-2113', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33954', 'C-2114', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33955', 'C-2115', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33956', 'C-2116', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33957', 'C-2117', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33958', 'C-2118', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33959', 'C-2119', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33960', 'C-2120', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33961', 'C-2121', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33962', 'C-2122', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33963', 'C-2123', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33964', 'C-2124', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33965', 'C-2125', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33966', 'C-2126', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33967', 'C-2127', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33968', 'C-2128', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33969', 'C-2129', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33970', 'C-2130', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33971', 'C-2131', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33972', 'C-2132', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33973', 'C-2133', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '1970-01-01');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33974', 'C-3000', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33975', 'C-3001', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33976', 'C-3002', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33977', 'C-3003', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33978', 'C-3004', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33979', 'C-3005', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33980', 'C-3006', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33981', 'C-3007', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33982', 'C-3008', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33983', 'C-3009', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33984', 'C-3010', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33985', 'C-3011', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33986', 'C-3012', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33987', 'C-3013', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33988', 'C-3014', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33989', 'C-3015', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33990', 'C-3016', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33991', 'C-3017', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33992', 'C-3018', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33993', 'C-3019', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33994', 'C-3020', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33995', 'C-3021', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33996', 'C-3022', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33997', 'C-3023', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33998', 'C-3024', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('33999', 'C-3025', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34000', 'C-3026', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34001', 'C-3027', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34002', 'C-3028', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34003', 'C-3029', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34004', 'C-3030', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34005', 'C-3031', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34006', 'C-3032', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34007', 'C-3033', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34008', 'C-3034', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34009', 'C-3035', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34010', 'C-3036', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34011', 'C-3037', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34012', 'C-3038', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34013', 'C-3039', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34014', 'C-3040', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34015', 'C-3041', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34016', 'C-3042', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34017', 'C-3043', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34018', 'C-3044', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34019', 'C-3045', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34020', 'C-3046', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34021', 'C-3047', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34022', 'C-3048', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34023', 'C-3049', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34024', 'C-3050', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34025', 'C-3051', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34026', 'C-3052', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34027', 'C-3053', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34028', 'C-3054', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34029', 'C-3055', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34030', 'C-3056', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34031', 'C-3057', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34032', 'C-3058', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34033', 'C-3059', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34034', 'C-3060', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34035', 'C-3061', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34036', 'C-3062', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34037', 'C-3063', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34038', 'C-3064', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34039', 'C-3065', ' - PLATA - PLOMO', '1240', 'CARLOS CHOQUE', '357', 'R-METALS', '', 'PLATA 16.06 DM Ag|PLOMO 19.15 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34040', 'C-3066', ' - ZINC - PLATA - PLOMO - HUMEDAD', '1241', 'IVO DELGADO', 'ID-063/23', 'S/P', '', 'ZINC 12.89 % Zn|PLATA 5.70 DM Ag|PLOMO 26.88 % Pb|HUMEDAD 9.20 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34041', 'C-3067', ' - ZINC - PLATA - HUMEDAD', '1242', 'IVO DELGADO', 'ID-081/23', 'S/P', '', 'ZINC 44.75 % Zn|PLATA 2.55 DM Ag|HUMEDAD 9.28 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34042', 'C-3068', '#?NOMBRE?', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34043', 'C-3069', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34044', 'C-3070', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34045', 'C-3071', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34046', 'C-3072', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34047', 'C-3073', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34048', 'C-3074', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34049', 'C-3075', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34050', 'C-3076', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34051', 'C-3077', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34052', 'C-3078', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34053', 'C-3079', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34054', 'C-3080', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34055', 'C-3081', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34056', 'C-3082', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34057', 'C-3083', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34058', 'C-3084', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34059', 'C-3085', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34060', 'C-3086', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34061', 'C-3087', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34062', 'C-3088', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34063', 'C-3089', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34064', 'C-3090', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34065', 'C-3091', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34066', 'C-3092', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34067', 'C-3093', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34068', 'C-3094', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34069', 'C-3095', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34070', 'C-3096', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34071', 'C-3097', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34072', 'C-3098', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34073', 'C-3099', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34074', 'C-3100', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34075', 'C-3101', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34076', 'C-3102', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34077', 'C-3103', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34078', 'C-3104', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34079', 'C-3105', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34080', 'C-3106', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34081', 'C-3107', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34082', 'C-3108', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34083', 'C-3109', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34084', 'C-3110', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34085', 'C-3111', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34086', 'C-3112', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34087', 'C-3113', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34088', 'C-3114', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34089', 'C-3115', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34090', 'C-3116', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34091', 'C-3117', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34092', 'C-3118', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34093', 'C-3119', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34094', 'C-3120', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34095', 'C-3121', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34096', 'C-3122', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34097', 'C-3123', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34098', 'C-3124', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34099', 'C-3125', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34100', 'C-3126', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34101', 'C-3127', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34102', 'C-3128', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34103', 'C-3129', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34104', 'C-3130', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34105', 'C-3131', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34106', 'C-3132', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34107', 'C-3133', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34108', 'C-4000', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34109', 'C-4001', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34110', 'C-4002', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34111', 'C-4003', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34112', 'C-4004', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34113', 'C-4005', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34114', 'C-4006', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34115', 'C-4007', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34116', 'C-4008', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34117', 'C-4009', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34118', 'C-4010', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34119', 'C-4011', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34120', 'C-4012', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34121', 'C-4013', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34122', 'C-4014', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34123', 'C-4015', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34124', 'C-4016', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34125', 'C-4017', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34126', 'C-4018', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34127', 'C-4019', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34128', 'C-4020', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34129', 'C-4021', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34130', 'C-4022', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34131', 'C-4023', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34132', 'C-4024', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34133', 'C-4025', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34134', 'C-4026', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34135', 'C-4027', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34136', 'C-4028', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34137', 'C-4029', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34138', 'C-4030', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34139', 'C-4031', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34140', 'C-4032', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34141', 'C-4033', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34142', 'C-4034', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34143', 'C-4035', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34144', 'C-4036', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34145', 'C-4037', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34146', 'C-4038', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34147', 'C-4039', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34148', 'C-4040', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34149', 'C-4041', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34150', 'C-4042', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34151', 'C-4043', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34152', 'C-4044', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34153', 'C-4045', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34154', 'C-4046', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34155', 'C-4047', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34156', 'C-4048', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34157', 'C-4049', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34158', 'C-4050', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34159', 'C-4051', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34160', 'C-4052', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34161', 'C-4053', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34162', 'C-4054', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34163', 'C-4055', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34164', 'C-4056', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34165', 'C-4057', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34166', 'C-4058', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34167', 'C-4059', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34168', 'C-4060', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34169', 'C-4061', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34170', 'C-4062', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34171', 'C-4063', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34172', 'C-4064', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34173', 'C-4065', ' - PLATA - PLOMO', '1240', 'CARLOS CHOQUE', '357', 'R-METALS', '', 'PLATA 16.06 DM Ag|PLOMO 19.15 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34174', 'C-4066', ' - ZINC - PLATA - PLOMO - HUMEDAD', '1241', 'IVO DELGADO', 'ID-063/23', 'S/P', '', 'ZINC 12.89 % Zn|PLATA 5.70 DM Ag|PLOMO 26.88 % Pb|HUMEDAD 9.20 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34175', 'C-4067', ' - ZINC - PLATA - HUMEDAD', '1242', 'IVO DELGADO', 'ID-081/23', 'S/P', '', 'ZINC 44.75 % Zn|PLATA 2.55 DM Ag|HUMEDAD 9.28 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34176', 'C-4068', '#?NOMBRE?', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34177', 'C-4069', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34178', 'C-4070', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34179', 'C-4071', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34180', 'C-4072', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34181', 'C-4073', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34182', 'C-4074', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34183', 'C-4075', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34184', 'C-4076', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34185', 'C-4077', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34186', 'C-4078', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34187', 'C-4079', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34188', 'C-4080', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34189', 'C-4081', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34190', 'C-4082', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34191', 'C-4083', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34192', 'C-4084', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34193', 'C-4085', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34194', 'C-4086', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34195', 'C-4087', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34196', 'C-4088', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34197', 'C-4089', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34198', 'C-4090', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34199', 'C-4091', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34200', 'C-4092', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34201', 'C-4093', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34202', 'C-4094', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34203', 'C-4095', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34204', 'C-4096', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34205', 'C-4097', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34206', 'C-4098', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34207', 'C-4099', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34208', 'C-4100', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34209', 'C-4101', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34210', 'C-4102', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34211', 'C-4103', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34212', 'C-4104', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34213', 'C-4105', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34214', 'C-4106', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34215', 'C-4107', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34216', 'C-4108', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34217', 'C-4109', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34218', 'C-4110', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34219', 'C-4111', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34220', 'C-4112', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34221', 'C-4113', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34222', 'C-4114', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34223', 'C-4115', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34224', 'C-4116', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34225', 'C-4117', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34226', 'C-4118', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34227', 'C-4119', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34228', 'C-4120', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34229', 'C-4121', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34230', 'C-4122', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34231', 'C-4123', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34232', 'C-4124', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34233', 'C-4125', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34234', 'C-4126', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34235', 'C-4127', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34236', 'C-4128', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34237', 'C-4129', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34238', 'C-4130', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34239', 'C-4131', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34240', 'C-4132', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34241', 'C-4133', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34242', 'C-5000', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34243', 'C-5001', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34244', 'C-5002', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34245', 'C-5003', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34246', 'C-5004', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34247', 'C-5005', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34248', 'C-5006', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34249', 'C-5007', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34250', 'C-5008', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34251', 'C-5009', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34252', 'C-5010', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34253', 'C-5011', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34254', 'C-5012', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34255', 'C-5013', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34256', 'C-5014', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34257', 'C-5015', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34258', 'C-5016', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34259', 'C-5017', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34260', 'C-5018', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34261', 'C-5019', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34262', 'C-5020', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34263', 'C-5021', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34264', 'C-5022', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34265', 'C-5023', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34266', 'C-5024', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34267', 'C-5025', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34268', 'C-5026', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34269', 'C-5027', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34270', 'C-5028', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34271', 'C-5029', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34272', 'C-5030', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34273', 'C-5031', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34274', 'C-5032', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34275', 'C-5033', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34276', 'C-5034', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34277', 'C-5035', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34278', 'C-5036', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34279', 'C-5037', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34280', 'C-5038', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34281', 'C-5039', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34282', 'C-5040', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34283', 'C-5041', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34284', 'C-5042', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34285', 'C-5043', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34286', 'C-5044', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34287', 'C-5045', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34288', 'C-5046', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34289', 'C-5047', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34290', 'C-5048', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34291', 'C-5049', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34292', 'C-5050', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34293', 'C-5051', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34294', 'C-5052', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34295', 'C-5053', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34296', 'C-5054', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34297', 'C-5055', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34298', 'C-5056', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34299', 'C-5057', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34300', 'C-5058', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34301', 'C-5059', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34302', 'C-5060', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34303', 'C-5061', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34304', 'C-5062', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34305', 'C-5063', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34306', 'C-5064', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34307', 'C-5065', ' - PLATA - PLOMO', '1240', 'CARLOS CHOQUE', '357', 'R-METALS', '', 'PLATA 16.06 DM Ag|PLOMO 19.15 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34308', 'C-5066', ' - ZINC - PLATA - PLOMO - HUMEDAD', '1241', 'IVO DELGADO', 'ID-063/23', 'S/P', '', 'ZINC 12.89 % Zn|PLATA 5.70 DM Ag|PLOMO 26.88 % Pb|HUMEDAD 9.20 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34309', 'C-5067', ' - ZINC - PLATA - HUMEDAD', '1242', 'IVO DELGADO', 'ID-081/23', 'S/P', '', 'ZINC 44.75 % Zn|PLATA 2.55 DM Ag|HUMEDAD 9.28 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34310', 'C-5068', '#?NOMBRE?', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34311', 'C-5069', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34312', 'C-5070', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34313', 'C-5071', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34314', 'C-5072', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34315', 'C-5073', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34316', 'C-5074', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34317', 'C-5075', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34318', 'C-5076', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34319', 'C-5077', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34320', 'C-5078', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34321', 'C-5079', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34322', 'C-5080', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34323', 'C-5081', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34324', 'C-5082', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34325', 'C-5083', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34326', 'C-5084', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34327', 'C-5085', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34328', 'C-5086', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34329', 'C-5087', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34330', 'C-5088', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34331', 'C-5089', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34332', 'C-5090', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34333', 'C-5091', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34334', 'C-5092', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34335', 'C-5093', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34336', 'C-5094', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34337', 'C-5095', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34338', 'C-5096', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34339', 'C-5097', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34340', 'C-5098', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34341', 'C-5099', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34342', 'C-5100', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34343', 'C-5101', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34344', 'C-5102', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34345', 'C-5103', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34346', 'C-5104', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34347', 'C-5105', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34348', 'C-5106', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34349', 'C-5107', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34350', 'C-5108', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34351', 'C-5109', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34352', 'C-5110', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34353', 'C-5111', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34354', 'C-5112', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34355', 'C-5113', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34356', 'C-5114', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34357', 'C-5115', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34358', 'C-5116', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34359', 'C-5117', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34360', 'C-5118', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34361', 'C-5119', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34362', 'C-5120', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34363', 'C-5121', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34364', 'C-5122', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34365', 'C-5123', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34366', 'C-5124', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34367', 'C-5125', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34368', 'C-5126', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34369', 'C-5127', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34370', 'C-5128', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34371', 'C-5129', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34372', 'C-5130', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34373', 'C-5131', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34374', 'C-5132', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34375', 'C-5133', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34376', 'C-6000', ' - PLATA', '1243', 'MIGUEL MANCILLA', '1489', 'ESTIRPE DE PLATA', '', 'PLATA 496.59 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34377', 'C-6001', ' - ZINC - PLATA - PLOMO', '1244', 'RICARDO QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 5.50 % Zn|PLATA 1.76 DM Ag|PLOMO 2.10 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34378', 'C-6002', ' - ZINC - PLATA', '1245', 'JOSE MIGUEL RAMOS', 'VAL3-316', 'MISERICORDIA S.R.L.', '', 'ZINC 15.25 % Zn|PLATA 0.86 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34379', 'C-6003', ' - ZINC - PLATA', '1246', 'BEYMAR SUARES', 'VAL3-318', 'MISERICORDIA S.R.L.', '', 'ZINC 9.03 % Zn|PLATA 1.32 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34380', 'C-6004', ' - PLATA - PLOMO', '1247', 'RAUL IBARRA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 11.30 DM Ag|PLOMO 52.39 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34381', 'C-6005', ' - ZINC', '1248', 'LAMBOL MINA CONDOR ', '23L03613', 'LAMBOL S.A.', '', 'ZINC 5.55 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34382', 'C-6006', ' - ZINC', '1249', 'CELSO SOLIZ', '29', 'RIO DE PLATA', '', 'ZINC 9.78 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34383', 'C-6007', ' - ZINC', '1250', 'IGOR GOMEZ', '62', 'RIO DE PLATA', '', 'ZINC 6.88 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34384', 'C-6008', ' - ZINC', '1251', 'CELSO SOLIZ', '50', 'RIO DE PLATA', '', 'ZINC 11.41 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34385', 'C-6009', ' - ZINC - PLATA - PLOMO', '1252', 'EULOGIO ARICOMA', '5158', 'ALDEEXPORMIN', '', 'ZINC 23.89 % Zn|PLATA 8.08 DM Ag|PLOMO 10.30 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34386', 'C-6010', ' - ZINC - PLATA - PLOMO', '1253', 'GONZALO HUARACHI', '5156', 'ALDEEXPORMIN', '', 'ZINC 26.06 % Zn|PLATA 8.60 DM Ag|PLOMO 6.40 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34387', 'C-6011', ' - ZINC - PLATA - PLOMO', '1254', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0602-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.89 % Zn|PLATA 4.40 DM Ag|PLOMO 5.55 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34388', 'C-6012', ' - ZINC - PLATA - PLOMO', '1255', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0611-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 4.77 % Zn|PLATA 3.46 DM Ag|PLOMO 7.40 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34389', 'C-6013', ' - ZINC - PLATA - PLOMO', '1256', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0613-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.19 % Zn|PLATA 4.70 DM Ag|PLOMO 5.15 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34390', 'C-6014', ' - ZINC', '1257', 'OSCAR VILLCA', 'COLA', 'S/P', '', 'ZINC 0.68 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34391', 'C-6015', ' - PLATA', '1258', 'OSCAR VILLCA', 'CONCENTRADO', 'S/P', '', 'PLATA 60.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34392', 'C-6016', ' - PLATA', '1259', 'MINEXA S.R.L. ', 'MMNEE', 'MINEXA S.R.L.', '', 'PLATA 583.88 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34393', 'C-6017', ' - PLATA', '1260', 'RENE TAPIA', 'SV-135', 'VETILLAS SRL.', '', 'PLATA 22.84 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34394', 'C-6018', ' - PLATA', '1261', 'JHON FLORES', '757', 'FENIX', '', 'PLATA 260.55 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34395', 'C-6019', ' - PLATA', '1262', 'JHON FLORES', '758', 'FENIX', '', 'PLATA 771.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34396', 'C-6020', ' - PLATA', '1263', 'JUAN ISLA', '64', 'EL MAJESTUOSO', '', 'PLATA 22.84 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34397', 'C-6021', ' - PLATA', '1264', 'RICHAR CUPARA', '22033', 'MINEXA S.R.L.', '', 'PLATA 585.50 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34398', 'C-6022', ' - PLATA', '1265', 'LUIS DELGADO', 'DRC-16', 'ANGELES', '', 'PLATA 249.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34399', 'C-6023', ' - PLATA', '1266', 'CELSO CRUZ GUTIERREZ', '3876', 'UNIFICADA POTOSI R.L.', '', 'PLATA 12.46 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34400', 'C-6024', ' - PLATA', '1267', 'CARLOS FLORES', '6910', 'COEXMIN S.R.L.', '', 'PLATA 240.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34401', 'C-6025', ' - PLATA', '1268', 'SINFORIANO PUMA', '5693', 'EMCON S.R.L.', '', 'PLATA 56.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34402', 'C-6026', ' - PLATA', '1269', 'ABELIÑO GUTIERREZ', '3090', 'CKACHAS S.R.L.', '', 'PLATA 205.17 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34403', 'C-6027', ' - PLATA', '1270', 'ABELINO GUTIERREZ', '3095', 'CKACHAS S.R.L.', '', 'PLATA 365.18 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34404', 'C-6028', ' - ESTAÑO', '1271', 'JORGE FERNANDEZ', '1653', 'SAN JUAN J.A.M.', '', 'ESTAÑO 22.39 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34405', 'C-6029', ' - PLATA', '1272', 'JUAN TACURI', '01-TACURI', 'FENIX', '', 'PLATA 4.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34406', 'C-6030', ' - ZINC - PLATA', '1273', 'WILSON O.', '12', 'S/P', '', 'ZINC 12.05 % Zn|PLATA 1.80 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34407', 'C-6031', ' - ZINC - PLATA', '1274', 'WILSON O.', '11', 'S/P', '', 'ZINC 13.56 % Zn|PLATA 2.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34408', 'C-6032', ' - PLATA', '1275', 'CRISTIAN CALDERON', 'CC-2502', 'S/P', '', 'PLATA 2.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34409', 'C-6033', ' - ZINC', '1276', 'ESEGUIEL RUIZ', 'LM-2191', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.05 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34410', 'C-6034', ' - ZINC - PLATA - PLOMO', '1277', 'COOP. HUAYNA PORCO', 'LM-2170', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.89 % Zn|PLATA 2.30 DM Ag|PLOMO 7.70 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34411', 'C-6035', ' - ZINC - PLATA', '1278', 'WALTER RAMOS', 'MUESTRA ESPECIAL', 'S/P', '', 'ZINC 20.21 % Zn|PLATA 1.65 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34412', 'C-6036', ' - ZINC - PLATA', '1279', 'ROLANDO COPA', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 51.89 % Zn|PLATA 2.03 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34413', 'C-6037', ' - PLATA', '1280', 'JORGE CRUZ', 'SPA-AG-40', 'SINCHI PUKARA S.R.L.', '', 'PLATA 3.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34414', 'C-6038', ' - ZINC', '1281', 'LEANDRO SUYO', '1907-23', 'IMSUR', '', 'ZINC 2.50 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34415', 'C-6039', ' - PLATA', '1282', 'JHONNY MAMANI', 'PBX1', 'FENIX', '', 'PLATA 8.65 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34416', 'C-6040', ' - PLATA', '1283', 'JHONY MAMANI', '02-R', 'FENIX', '', 'PLATA 1.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34417', 'C-6041', ' - ZINC - PLATA - PLOMO', '1284', 'PLACIDO COPA MARTINEZ', 'C-10287', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 5.70 % Zn|PLATA 1.40 DM Ag|PLOMO 0.45 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34418', 'C-6042', ' - ZINC', '1285', 'GONZALO LIMACHI', 'C-10291', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 8.55 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34419', 'C-6043', ' - ZINC - PLATA', '1286', 'ALVARO SAAVEDRA', 'C-10289', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 4.10 % Zn|PLATA 1.85 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34420', 'C-6044', ' - PLATA', '1287', 'LUIS CRUZ', 'C-0161', 'REDMETALS R.R.L.', '', 'PLATA 3.10 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34421', 'C-6045', ' - PLATA', '1288', 'LUIS CRUZ', 'C-0160', 'REDMETALS R.R.L.', '', 'PLATA 3.35 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34422', 'C-6046', ' - ZINC - PLATA', '1289', 'ALVARO SAAVEDRA', 'C-10288', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 3.30 % Zn|PLATA 1.66 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34423', 'C-6047', ' - PLATA', '1290', 'JORGE CRUZ', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 4.25 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34424', 'C-6048', ' - PLATA', '1291', 'ALEXANDER CHIPANA', 'M-109', 'CAMPO VERDE', '', 'PLATA 3.20 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34425', 'C-6049', ' - ZINC', '1292', 'FLORENCIO CONDORI', 'LM-2189', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 11.58 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34426', 'C-6050', ' - ZINC - PLATA', '1293', 'JORGE LUIS COPACABA CRUZ', 'MRB-2122', 'RODRIGUEZJM S.R.L.', '', 'ZINC 18.88 % Zn|PLATA 8.45 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34427', 'C-6051', ' - ZINC', '1294', 'DAVID ALVAREZ', 'LM-2201', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 12.05 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34428', 'C-6052', ' - ZINC - PLATA', '1295', 'CIRILO LUNASCO CANSECO', 'CV-730', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 19.60 % Zn|PLATA 1.07 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34429', 'C-6053', ' - ZINC - PLATA', '1296', 'CIRILO LUNASCO CANSECO', 'CV-732', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 25.41 % Zn|PLATA 1.11 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34430', 'C-6054', ' - ZINC - PLATA', '1297', 'CIRILO LUNASCO CANSECO', 'CV-726', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 21.89 % Zn|PLATA 1.05 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34431', 'C-6055', ' - ZINC', '1298', 'DAVID ALVAREZ', 'LM-2202', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.12 % Zn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34432', 'C-6056', ' - ZINC - PLATA', '1299', 'CIRILO LUNASCO CANSECO', 'CV-734', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 18.67 % Zn|PLATA 1.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34433', 'C-6057', ' - ZINC - PLATA', '1300', 'CIRILO LUNASCO CANSECO', 'CV-731', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 27.18 % Zn|PLATA 1.13 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34434', 'C-6058', ' - ZINC - PLATA', '1301', 'CIRILO LUNASCO CANSECO', 'CV-728', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 20.04 % Zn|PLATA 0.89 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34435', 'C-6059', ' - ZINC - PLATA', '1302', 'CIRILO LUNASCO CANSECO', 'CV-727', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 29.14 % Zn|PLATA 1.31 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34436', 'C-6060', ' - ZINC - PLATA', '1303', 'SERAPIO PORTILLO SERRANO', 'CC-0626/23', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.70 % Zn|PLATA 1.08 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34437', 'C-6061', ' - ESTAÑO', '1304', 'C.T.S. ', 'MUESTRA ESPECIAL -1', 'S/P', '', 'ESTAÑO 1.04 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34438', 'C-6062', ' - ESTAÑO', '1305', 'C.T.S. ', 'MUESTRA ESPECIAL -2', 'S/P', '', 'ESTAÑO 0.41 % Sn|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34439', 'C-6063', ' - ZINC - PLATA - HUMEDAD', '1306', 'GREGORIO CHOQUE', 'FM-13/23', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 33.58 % Zn|PLATA 6.11 DM Ag|HUMEDAD 8.89 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34440', 'C-6064', ' - PLATA', '1307', 'TEODORO RAMIREZ', 'L-AG/0396', 'ISMAR S.R.L.', '', 'PLATA 134.68 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34441', 'C-6065', ' - PLATA - PLOMO', '1308', 'NELSON CALLA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|PLOMO 30.11 % Pb|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34442', 'C-6066', ' - PLATA', '1309', 'JANNETH IGLESIAS', 'SV-137', 'VETILLAS SRL.', '', 'PLATA 245.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34443', 'C-6067', ' - PLATA - HUMEDAD', '1310', 'GREGORIO CHOQUE', '1', 'VIRGEN DE COTOCA S.R.L.', '', 'PLATA 33.64 DM Ag|HUMEDAD 7.90 % H2O|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34444', 'C-6068', ' - PLATA', '1311', 'ALBERTO GALLARDO', '5695', 'EMCON S.R.L.', '', 'PLATA 120.17 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34445', 'C-6069', ' - PLATA', '1312', 'GREGORIO CHOQUE', '1580', 'PUENTE DE PLATA S.R.L.', '', 'PLATA 44.15 DM Ag|', '0000-00-00');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34446', 'C-7000', ' - PLATA', '1243', 'MIGUEL MANCILLA', '1489', 'ESTIRPE DE PLATA', '', 'PLATA 496.59 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34447', 'C-7001', ' - ZINC - PLATA - PLOMO', '1244', 'RICARDO QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 5.50 % Zn|PLATA 1.76 DM Ag|PLOMO 2.10 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34448', 'C-7002', ' - ZINC - PLATA', '1245', 'JOSE MIGUEL RAMOS', 'VAL3-316', 'MISERICORDIA S.R.L.', '', 'ZINC 15.25 % Zn|PLATA 0.86 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34449', 'C-7003', ' - ZINC - PLATA', '1246', 'BEYMAR SUARES', 'VAL3-318', 'MISERICORDIA S.R.L.', '', 'ZINC 9.03 % Zn|PLATA 1.32 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34450', 'C-7004', ' - PLATA - PLOMO', '1247', 'RAUL IBARRA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 11.30 DM Ag|PLOMO 52.39 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34451', 'C-7005', ' - ZINC', '1248', 'LAMBOL MINA CONDOR ', '23L03613', 'LAMBOL S.A.', '', 'ZINC 5.55 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34452', 'C-7006', ' - ZINC', '1249', 'CELSO SOLIZ', '29', 'RIO DE PLATA', '', 'ZINC 9.78 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34453', 'C-7007', ' - ZINC', '1250', 'IGOR GOMEZ', '62', 'RIO DE PLATA', '', 'ZINC 6.88 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34454', 'C-7008', ' - ZINC', '1251', 'CELSO SOLIZ', '50', 'RIO DE PLATA', '', 'ZINC 11.41 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34455', 'C-7009', ' - ZINC - PLATA - PLOMO', '1252', 'EULOGIO ARICOMA', '5158', 'ALDEEXPORMIN', '', 'ZINC 23.89 % Zn|PLATA 8.08 DM Ag|PLOMO 10.30 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34456', 'C-7010', ' - ZINC - PLATA - PLOMO', '1253', 'GONZALO HUARACHI', '5156', 'ALDEEXPORMIN', '', 'ZINC 26.06 % Zn|PLATA 8.60 DM Ag|PLOMO 6.40 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34457', 'C-7011', ' - ZINC - PLATA - PLOMO', '1254', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0602-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.89 % Zn|PLATA 4.40 DM Ag|PLOMO 5.55 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34458', 'C-7012', ' - ZINC - PLATA - PLOMO', '1255', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0611-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 4.77 % Zn|PLATA 3.46 DM Ag|PLOMO 7.40 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34459', 'C-7013', ' - ZINC - PLATA - PLOMO', '1256', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0613-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.19 % Zn|PLATA 4.70 DM Ag|PLOMO 5.15 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34460', 'C-7014', ' - ZINC', '1257', 'OSCAR VILLCA', 'COLA', 'S/P', '', 'ZINC 0.68 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34461', 'C-7015', ' - PLATA', '1258', 'OSCAR VILLCA', 'CONCENTRADO', 'S/P', '', 'PLATA 60.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34462', 'C-7016', ' - PLATA', '1259', 'MINEXA S.R.L. ', 'MMNEE', 'MINEXA S.R.L.', '', 'PLATA 583.88 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34463', 'C-7017', ' - PLATA', '1260', 'RENE TAPIA', 'SV-135', 'VETILLAS SRL.', '', 'PLATA 22.84 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34464', 'C-7018', ' - PLATA', '1261', 'JHON FLORES', '757', 'FENIX', '', 'PLATA 260.55 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34465', 'C-7019', ' - PLATA', '1262', 'JHON FLORES', '758', 'FENIX', '', 'PLATA 771.11 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34466', 'C-7020', ' - PLATA', '1263', 'JUAN ISLA', '64', 'EL MAJESTUOSO', '', 'PLATA 22.84 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34467', 'C-7021', ' - PLATA', '1264', 'RICHAR CUPARA', '22033', 'MINEXA S.R.L.', '', 'PLATA 585.50 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34468', 'C-7022', ' - PLATA', '1265', 'LUIS DELGADO', 'DRC-16', 'ANGELES', '', 'PLATA 249.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34469', 'C-7023', ' - PLATA', '1266', 'CELSO CRUZ GUTIERREZ', '3876', 'UNIFICADA POTOSI R.L.', '', 'PLATA 12.46 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34470', 'C-7024', ' - PLATA', '1267', 'CARLOS FLORES', '6910', 'COEXMIN S.R.L.', '', 'PLATA 240.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34471', 'C-7025', ' - PLATA', '1268', 'SINFORIANO PUMA', '5693', 'EMCON S.R.L.', '', 'PLATA 56.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34472', 'C-7026', ' - PLATA', '1269', 'ABELIÑO GUTIERREZ', '3090', 'CKACHAS S.R.L.', '', 'PLATA 205.17 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34473', 'C-7027', ' - PLATA', '1270', 'ABELINO GUTIERREZ', '3095', 'CKACHAS S.R.L.', '', 'PLATA 365.18 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34474', 'C-7028', ' - ESTAÑO', '1271', 'JORGE FERNANDEZ', '1653', 'SAN JUAN J.A.M.', '', 'ESTAÑO 22.39 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34475', 'C-7029', ' - PLATA', '1272', 'JUAN TACURI', '01-TACURI', 'FENIX', '', 'PLATA 4.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34476', 'C-7030', ' - ZINC - PLATA', '1273', 'WILSON O.', '12', 'S/P', '', 'ZINC 12.05 % Zn|PLATA 1.80 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34477', 'C-7031', ' - ZINC - PLATA', '1274', 'WILSON O.', '11', 'S/P', '', 'ZINC 13.56 % Zn|PLATA 2.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34478', 'C-7032', ' - PLATA', '1275', 'CRISTIAN CALDERON', 'CC-2502', 'S/P', '', 'PLATA 2.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34479', 'C-7033', ' - ZINC', '1276', 'ESEGUIEL RUIZ', 'LM-2191', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.05 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34480', 'C-7034', ' - ZINC - PLATA - PLOMO', '1277', 'COOP. HUAYNA PORCO', 'LM-2170', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.89 % Zn|PLATA 2.30 DM Ag|PLOMO 7.70 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34481', 'C-7035', ' - ZINC - PLATA', '1278', 'WALTER RAMOS', 'MUESTRA ESPECIAL', 'S/P', '', 'ZINC 20.21 % Zn|PLATA 1.65 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34482', 'C-7036', ' - ZINC - PLATA', '1279', 'ROLANDO COPA', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 51.89 % Zn|PLATA 2.03 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34483', 'C-7037', ' - PLATA', '1280', 'JORGE CRUZ', 'SPA-AG-40', 'SINCHI PUKARA S.R.L.', '', 'PLATA 3.85 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34484', 'C-7038', ' - ZINC', '1281', 'LEANDRO SUYO', '1907-23', 'IMSUR', '', 'ZINC 2.50 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34485', 'C-7039', ' - PLATA', '1282', 'JHONNY MAMANI', 'PBX1', 'FENIX', '', 'PLATA 8.65 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34486', 'C-7040', ' - PLATA', '1283', 'JHONY MAMANI', '02-R', 'FENIX', '', 'PLATA 1.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34487', 'C-7041', ' - ZINC - PLATA - PLOMO', '1284', 'PLACIDO COPA MARTINEZ', 'C-10287', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 5.70 % Zn|PLATA 1.40 DM Ag|PLOMO 0.45 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34488', 'C-7042', ' - ZINC', '1285', 'GONZALO LIMACHI', 'C-10291', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 8.55 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34489', 'C-7043', ' - ZINC - PLATA', '1286', 'ALVARO SAAVEDRA', 'C-10289', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 4.10 % Zn|PLATA 1.85 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34490', 'C-7044', ' - PLATA', '1287', 'LUIS CRUZ', 'C-0161', 'REDMETALS R.R.L.', '', 'PLATA 3.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34491', 'C-7045', ' - PLATA', '1288', 'LUIS CRUZ', 'C-0160', 'REDMETALS R.R.L.', '', 'PLATA 3.35 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34492', 'C-7046', ' - ZINC - PLATA', '1289', 'ALVARO SAAVEDRA', 'C-10288', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 3.30 % Zn|PLATA 1.66 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34493', 'C-7047', ' - PLATA', '1290', 'JORGE CRUZ', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 4.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34494', 'C-7048', ' - PLATA', '1291', 'ALEXANDER CHIPANA', 'M-109', 'CAMPO VERDE', '', 'PLATA 3.20 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34495', 'C-7049', ' - ZINC', '1292', 'FLORENCIO CONDORI', 'LM-2189', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 11.58 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34496', 'C-7050', ' - ZINC - PLATA', '1293', 'JORGE LUIS COPACABA CRUZ', 'MRB-2122', 'RODRIGUEZJM S.R.L.', '', 'ZINC 18.88 % Zn|PLATA 8.45 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34497', 'C-7051', ' - ZINC', '1294', 'DAVID ALVAREZ', 'LM-2201', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 12.05 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34498', 'C-7052', ' - ZINC - PLATA', '1295', 'CIRILO LUNASCO CANSECO', 'CV-730', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 19.60 % Zn|PLATA 1.07 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34499', 'C-7053', ' - ZINC - PLATA', '1296', 'CIRILO LUNASCO CANSECO', 'CV-732', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 25.41 % Zn|PLATA 1.11 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34500', 'C-7054', ' - ZINC - PLATA', '1297', 'CIRILO LUNASCO CANSECO', 'CV-726', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 21.89 % Zn|PLATA 1.05 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34501', 'C-7055', ' - ZINC', '1298', 'DAVID ALVAREZ', 'LM-2202', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.12 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34502', 'C-7056', ' - ZINC - PLATA', '1299', 'CIRILO LUNASCO CANSECO', 'CV-734', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 18.67 % Zn|PLATA 1.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34503', 'C-7057', ' - ZINC - PLATA', '1300', 'CIRILO LUNASCO CANSECO', 'CV-731', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 27.18 % Zn|PLATA 1.13 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34504', 'C-7058', ' - ZINC - PLATA', '1301', 'CIRILO LUNASCO CANSECO', 'CV-728', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 20.04 % Zn|PLATA 0.89 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34505', 'C-7059', ' - ZINC - PLATA', '1302', 'CIRILO LUNASCO CANSECO', 'CV-727', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 29.14 % Zn|PLATA 1.31 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34506', 'C-7060', ' - ZINC - PLATA', '1303', 'SERAPIO PORTILLO SERRANO', 'CC-0626/23', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.70 % Zn|PLATA 1.08 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34507', 'C-7061', ' - ESTAÑO', '1304', 'C.T.S. ', 'MUESTRA ESPECIAL -1', 'S/P', '', 'ESTAÑO 1.04 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34508', 'C-7062', ' - ESTAÑO', '1305', 'C.T.S. ', 'MUESTRA ESPECIAL -2', 'S/P', '', 'ESTAÑO 0.41 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34509', 'C-7063', ' - ZINC - PLATA - HUMEDAD', '1306', 'GREGORIO CHOQUE', 'FM-13/23', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 33.58 % Zn|PLATA 6.11 DM Ag|HUMEDAD 8.89 % H2O|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34510', 'C-7064', ' - PLATA', '1307', 'TEODORO RAMIREZ', 'L-AG/0396', 'ISMAR S.R.L.', '', 'PLATA 134.68 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34511', 'C-7065', ' - PLATA - PLOMO', '1308', 'NELSON CALLA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|PLOMO 30.11 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34512', 'C-7066', ' - PLATA', '1309', 'JANNETH IGLESIAS', 'SV-137', 'VETILLAS SRL.', '', 'PLATA 245.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34513', 'C-7067', ' - PLATA - HUMEDAD', '1310', 'GREGORIO CHOQUE', '1', 'VIRGEN DE COTOCA S.R.L.', '', 'PLATA 33.64 DM Ag|HUMEDAD 7.90 % H2O|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34514', 'C-7068', ' - PLATA', '1311', 'ALBERTO GALLARDO', '5695', 'EMCON S.R.L.', '', 'PLATA 120.17 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34515', 'C-7069', ' - PLATA', '1312', 'GREGORIO CHOQUE', '1580', 'PUENTE DE PLATA S.R.L.', '', 'PLATA 44.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34516', 'U-100', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34517', 'U-101', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34518', 'U-102', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34519', 'U-103', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34520', 'U-104', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34521', 'U-105', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34522', 'U-106', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34523', 'U-107', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34524', 'U-108', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34525', 'U-109', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34526', 'U-110', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34527', 'U-111', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34528', 'U-112', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34529', 'U-113', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34530', 'U-114', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34531', 'U-115', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34532', 'U-116', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34533', 'U-117', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34534', 'U-118', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34535', 'U-119', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34536', 'U-120', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34537', 'U-121', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34538', 'U-122', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34539', 'U-123', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34540', 'U-124', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34541', 'U-125', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34542', 'U-126', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34543', 'U-127', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34544', 'U-128', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34545', 'U-129', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34546', 'U-130', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34547', 'U-131', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34548', 'U-132', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34549', 'U-133', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34550', 'U-134', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34551', 'U-135', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34552', 'U-136', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34553', 'U-137', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34554', 'U-138', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34555', 'U-139', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34556', 'U-140', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34557', 'U-141', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34558', 'U-142', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34559', 'U-143', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34560', 'U-144', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34561', 'U-145', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34562', 'U-146', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34563', 'U-147', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34564', 'U-148', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34565', 'U-149', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34566', 'U-150', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34567', 'U-151', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34568', 'U-152', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34569', 'U-153', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34570', 'U-154', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34571', 'U-155', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34572', 'U-156', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34573', 'U-157', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34574', 'U-158', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34575', 'U-159', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34576', 'U-160', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34577', 'U-161', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34578', 'U-162', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34579', 'U-163', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34580', 'U-164', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34581', 'U-165', ' - PLATA - PLOMO', '1240', 'CARLOS CHOQUE', '357', 'R-METALS', '', 'PLATA 16.06 DM Ag|PLOMO 19.15 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34582', 'U-166', ' - ZINC - PLATA - PLOMO - HUMEDAD', '1241', 'IVO DELGADO', 'ID-063/23', 'S/P', '', 'ZINC 12.89 % Zn|PLATA 5.70 DM Ag|PLOMO 26.88 % Pb|HUMEDAD 9.20 % H2O|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34583', 'U-167', ' - ZINC - PLATA - HUMEDAD', '1242', 'IVO DELGADO', 'ID-081/23', 'S/P', '', 'ZINC 44.75 % Zn|PLATA 2.55 DM Ag|HUMEDAD 9.28 % H2O|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34584', 'U-168', ' - PLATA', '1243', 'MIGUEL MANCILLA', '1489', 'ESTIRPE DE PLATA', '', 'PLATA 496.59 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34585', 'U-169', ' - ZINC - PLATA - PLOMO', '1244', 'RICARDO QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 5.50 % Zn|PLATA 1.76 DM Ag|PLOMO 2.10 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34586', 'U-170', ' - ZINC - PLATA', '1245', 'JOSE MIGUEL RAMOS', 'VAL3-316', 'MISERICORDIA S.R.L.', '', 'ZINC 15.25 % Zn|PLATA 0.86 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34587', 'U-171', ' - ZINC - PLATA', '1246', 'BEYMAR SUARES', 'VAL3-318', 'MISERICORDIA S.R.L.', '', 'ZINC 9.03 % Zn|PLATA 1.32 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34588', 'U-172', ' - PLATA - PLOMO', '1247', 'RAUL IBARRA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 11.30 DM Ag|PLOMO 52.39 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34589', 'U-173', ' - ZINC', '1248', 'LAMBOL MINA CONDOR ', '23L03613', 'LAMBOL S.A.', '', 'ZINC 5.55 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34590', 'U-174', ' - ZINC', '1249', 'CELSO SOLIZ', '29', 'RIO DE PLATA', '', 'ZINC 9.78 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34591', 'U-175', ' - ZINC', '1250', 'IGOR GOMEZ', '62', 'RIO DE PLATA', '', 'ZINC 6.88 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34592', 'U-176', ' - ZINC', '1251', 'CELSO SOLIZ', '50', 'RIO DE PLATA', '', 'ZINC 11.41 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34593', 'U-177', ' - ZINC - PLATA - PLOMO', '1252', 'EULOGIO ARICOMA', '5158', 'ALDEEXPORMIN', '', 'ZINC 23.89 % Zn|PLATA 8.08 DM Ag|PLOMO 10.30 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34594', 'U-178', ' - ZINC - PLATA - PLOMO', '1253', 'GONZALO HUARACHI', '5156', 'ALDEEXPORMIN', '', 'ZINC 26.06 % Zn|PLATA 8.60 DM Ag|PLOMO 6.40 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34595', 'U-179', ' - ZINC - PLATA - PLOMO', '1254', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0602-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.89 % Zn|PLATA 4.40 DM Ag|PLOMO 5.55 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34596', 'U-180', ' - ZINC - PLATA - PLOMO', '1255', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0611-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 4.77 % Zn|PLATA 3.46 DM Ag|PLOMO 7.40 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34597', 'U-181', ' - ZINC - PLATA - PLOMO', '1256', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0613-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.19 % Zn|PLATA 4.70 DM Ag|PLOMO 5.15 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34598', 'U-182', ' - ZINC', '1257', 'OSCAR VILLCA', 'COLA', 'S/P', '', 'ZINC 0.68 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34599', 'U-183', ' - PLATA', '1258', 'OSCAR VILLCA', 'CONCENTRADO', 'S/P', '', 'PLATA 60.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34600', 'U-184', ' - PLATA', '1259', 'MINEXA S.R.L. ', 'MMNEE', 'MINEXA S.R.L.', '', 'PLATA 583.88 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34601', 'U-185', ' - PLATA', '1260', 'RENE TAPIA', 'SV-135', 'VETILLAS SRL.', '', 'PLATA 22.84 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34602', 'U-186', ' - PLATA', '1261', 'JHON FLORES', '757', 'FENIX', '', 'PLATA 260.55 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34603', 'U-187', ' - PLATA', '1262', 'JHON FLORES', '758', 'FENIX', '', 'PLATA 771.11 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34604', 'U-188', ' - PLATA', '1263', 'JUAN ISLA', '64', 'EL MAJESTUOSO', '', 'PLATA 22.84 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34605', 'U-189', ' - PLATA', '1264', 'RICHAR CUPARA', '22033', 'MINEXA S.R.L.', '', 'PLATA 585.50 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34606', 'U-190', ' - PLATA', '1265', 'LUIS DELGADO', 'DRC-16', 'ANGELES', '', 'PLATA 249.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34607', 'U-191', ' - PLATA', '1266', 'CELSO CRUZ GUTIERREZ', '3876', 'UNIFICADA POTOSI R.L.', '', 'PLATA 12.46 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34608', 'U-192', ' - PLATA', '1267', 'CARLOS FLORES', '6910', 'COEXMIN S.R.L.', '', 'PLATA 240.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34609', 'U-193', ' - PLATA', '1268', 'SINFORIANO PUMA', '5693', 'EMCON S.R.L.', '', 'PLATA 56.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34610', 'U-194', ' - PLATA', '1269', 'ABELIÑO GUTIERREZ', '3090', 'CKACHAS S.R.L.', '', 'PLATA 205.17 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34611', 'U-195', ' - PLATA', '1270', 'ABELINO GUTIERREZ', '3095', 'CKACHAS S.R.L.', '', 'PLATA 365.18 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34612', 'U-196', ' - ESTAÑO', '1271', 'JORGE FERNANDEZ', '1653', 'SAN JUAN J.A.M.', '', 'ESTAÑO 22.39 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34613', 'U-197', ' - PLATA', '1272', 'JUAN TACURI', '01-TACURI', 'FENIX', '', 'PLATA 4.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34614', 'U-198', ' - ZINC - PLATA', '1273', 'WILSON O.', '12', 'S/P', '', 'ZINC 12.05 % Zn|PLATA 1.80 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34615', 'U-199', ' - ZINC - PLATA', '1274', 'WILSON O.', '11', 'S/P', '', 'ZINC 13.56 % Zn|PLATA 2.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34616', 'U-200', ' - PLATA', '1275', 'CRISTIAN CALDERON', 'CC-2502', 'S/P', '', 'PLATA 2.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34617', 'U-201', ' - ZINC', '1276', 'ESEGUIEL RUIZ', 'LM-2191', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.05 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34618', 'U-202', ' - ZINC - PLATA - PLOMO', '1277', 'COOP. HUAYNA PORCO', 'LM-2170', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.89 % Zn|PLATA 2.30 DM Ag|PLOMO 7.70 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34619', 'U-203', ' - ZINC - PLATA', '1278', 'WALTER RAMOS', 'MUESTRA ESPECIAL', 'S/P', '', 'ZINC 20.21 % Zn|PLATA 1.65 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34620', 'U-204', ' - ZINC - PLATA', '1279', 'ROLANDO COPA', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 51.89 % Zn|PLATA 2.03 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34621', 'U-205', ' - PLATA', '1280', 'JORGE CRUZ', 'SPA-AG-40', 'SINCHI PUKARA S.R.L.', '', 'PLATA 3.85 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34622', 'U-206', ' - ZINC', '1281', 'LEANDRO SUYO', '1907-23', 'IMSUR', '', 'ZINC 2.50 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34623', 'U-207', ' - PLATA', '1282', 'JHONNY MAMANI', 'PBX1', 'FENIX', '', 'PLATA 8.65 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34624', 'U-208', ' - PLATA', '1283', 'JHONY MAMANI', '02-R', 'FENIX', '', 'PLATA 1.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34625', 'U-209', ' - ZINC - PLATA - PLOMO', '1284', 'PLACIDO COPA MARTINEZ', 'C-10287', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 5.70 % Zn|PLATA 1.40 DM Ag|PLOMO 0.45 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34626', 'U-210', ' - ZINC', '1285', 'GONZALO LIMACHI', 'C-10291', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 8.55 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34627', 'U-211', ' - ZINC - PLATA', '1286', 'ALVARO SAAVEDRA', 'C-10289', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 4.10 % Zn|PLATA 1.85 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34628', 'U-212', ' - PLATA', '1287', 'LUIS CRUZ', 'C-0161', 'REDMETALS R.R.L.', '', 'PLATA 3.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34629', 'U-213', ' - PLATA', '1288', 'LUIS CRUZ', 'C-0160', 'REDMETALS R.R.L.', '', 'PLATA 3.35 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34630', 'U-214', ' - ZINC - PLATA', '1289', 'ALVARO SAAVEDRA', 'C-10288', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 3.30 % Zn|PLATA 1.66 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34631', 'U-215', ' - PLATA', '1290', 'JORGE CRUZ', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 4.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34632', 'U-216', ' - PLATA', '1291', 'ALEXANDER CHIPANA', 'M-109', 'CAMPO VERDE', '', 'PLATA 3.20 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34633', 'U-217', ' - ZINC', '1292', 'FLORENCIO CONDORI', 'LM-2189', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 11.58 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34634', 'U-218', ' - ZINC - PLATA', '1293', 'JORGE LUIS COPACABA CRUZ', 'MRB-2122', 'RODRIGUEZJM S.R.L.', '', 'ZINC 18.88 % Zn|PLATA 8.45 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34635', 'U-219', ' - ZINC', '1294', 'DAVID ALVAREZ', 'LM-2201', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 12.05 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34636', 'U-220', ' - ZINC - PLATA', '1295', 'CIRILO LUNASCO CANSECO', 'CV-730', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 19.60 % Zn|PLATA 1.07 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34637', 'U-221', ' - ZINC - PLATA', '1296', 'CIRILO LUNASCO CANSECO', 'CV-732', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 25.41 % Zn|PLATA 1.11 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34638', 'U-222', ' - ZINC - PLATA', '1297', 'CIRILO LUNASCO CANSECO', 'CV-726', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 21.89 % Zn|PLATA 1.05 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34639', 'U-223', ' - ZINC', '1298', 'DAVID ALVAREZ', 'LM-2202', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.12 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34640', 'U-224', ' - ZINC - PLATA', '1299', 'CIRILO LUNASCO CANSECO', 'CV-734', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 18.67 % Zn|PLATA 1.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34641', 'U-225', ' - ZINC - PLATA', '1300', 'CIRILO LUNASCO CANSECO', 'CV-731', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 27.18 % Zn|PLATA 1.13 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34642', 'U-226', ' - ZINC - PLATA', '1301', 'CIRILO LUNASCO CANSECO', 'CV-728', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 20.04 % Zn|PLATA 0.89 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34643', 'U-227', ' - ZINC - PLATA', '1302', 'CIRILO LUNASCO CANSECO', 'CV-727', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 29.14 % Zn|PLATA 1.31 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34644', 'U-228', ' - ZINC - PLATA', '1303', 'SERAPIO PORTILLO SERRANO', 'CC-0626/23', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.70 % Zn|PLATA 1.08 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34645', 'U-229', ' - ESTAÑO', '1304', 'C.T.S. ', 'MUESTRA ESPECIAL -1', 'S/P', '', 'ESTAÑO 1.04 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34646', 'U-230', ' - ESTAÑO', '1305', 'C.T.S. ', 'MUESTRA ESPECIAL -2', 'S/P', '', 'ESTAÑO 0.41 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34647', 'U-231', ' - ZINC - PLATA - HUMEDAD', '1306', 'GREGORIO CHOQUE', 'FM-13/23', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 33.58 % Zn|PLATA 6.11 DM Ag|HUMEDAD 8.89 % H2O|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34648', 'U-232', ' - PLATA', '1307', 'TEODORO RAMIREZ', 'L-AG/0396', 'ISMAR S.R.L.', '', 'PLATA 134.68 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34649', 'U-233', ' - PLATA - PLOMO', '1308', 'NELSON CALLA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|PLOMO 30.11 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34650', 'U-234', ' - PLATA', '1309', 'JANNETH IGLESIAS', 'SV-137', 'VETILLAS SRL.', '', 'PLATA 245.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34651', 'U-235', ' - PLATA - HUMEDAD', '1310', 'GREGORIO CHOQUE', '1', 'VIRGEN DE COTOCA S.R.L.', '', 'PLATA 33.64 DM Ag|HUMEDAD 7.90 % H2O|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34652', 'U-236', ' - PLATA', '1311', 'ALBERTO GALLARDO', '5695', 'EMCON S.R.L.', '', 'PLATA 120.17 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34653', 'U-237', ' - PLATA', '1312', 'GREGORIO CHOQUE', '1580', 'PUENTE DE PLATA S.R.L.', '', 'PLATA 44.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34654', 'U-238', '#?NOMBRE?', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34655', 'U-239', ' - PLATA', '1175', 'ANGEL ZAMBRANA', 'CM-200', 'SAN CAYETHANO S.R.L.', '', 'PLATA 5.40 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34656', 'U-240', ' - ZINC', '1176', 'PEDRO HUANACO', 'JC-SK-30', 'CS', '', 'ZINC 13.03 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34657', 'U-241', ' - ZINC - PLATA', '1177', 'GABRIEL UÑO', 'MAX-304', 'LA ESCONDIDA S.R.L.', '', 'ZINC 9.20 % Zn|PLATA 0.61 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34658', 'U-242', ' - PLATA', '1178', 'ISIDRO ALVARES', 'RJ.300', 'S/P', '', 'PLATA 1.15 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34659', 'U-243', ' - PLATA', '1179', 'CLAUDIO CHUQUISEA', 'RJ.301', 'S/P', '', 'PLATA 3.60 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34660', 'U-244', ' - PLATA', '1180', 'PEDRO SUNIGA', '1895-23', 'IMSUR', '', 'PLATA 1.90 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34661', 'U-245', ' - ZINC - PLATA', '1181', 'MARCO COLQUE', 'RD-520', 'NUEVA GENERACION', '', 'ZINC 21.20 % Zn|PLATA 1.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34662', 'U-246', ' - ZINC - PLATA', '1182', 'TEOFILO CLEMENTE', 'RD-522', 'NUEVA GENERACION', '', 'ZINC 17.10 % Zn|PLATA 1.46 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34663', 'U-247', ' - ZINC - PLATA', '1183', 'WILBER GUTIERREZ VELIZ', 'CC-606-23-R', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.50 % Zn|PLATA 1.80 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34664', 'U-248', ' - PLATA', '1184', 'VICTOR ', 'M.E. 20-02', 'VIRGEN DE URKUPIÑA', '', 'PLATA 1926.48 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34665', 'U-249', ' - PLATA', '1185', 'LORENZO ARIAS', 'L:707', 'A & M', '', 'PLATA 316.31 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34666', 'U-250', ' - PLATA', '1186', 'ARMANDO MENACHO', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 1620.37 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34667', 'U-251', ' - PLATA', '1187', 'RICARDO ', 'M.E.-8', 'S/P', '', 'PLATA 983.64 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34668', 'U-252', ' - PLATA', '1188', 'RICARDO ', 'M.E.-7', 'S/P', '', 'PLATA 367.34 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34669', 'U-253', ' - PLATA', '1189', 'RICARDO ', 'M.E.-6', 'S/P', '', 'PLATA 195.19 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34670', 'U-254', ' - PLATA', '1190', 'JUAN CARLOS ROQUE ', 'SV-129', 'VETILLAS SRL.', '', 'PLATA 938.75 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34671', 'U-255', ' - PLATA', '1191', 'JUAN CARLOS ROQUE', 'SV-127', 'VETILLAS SRL.', '', 'PLATA 428.56 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34672', 'U-256', ' - PLATA', '1192', 'JUAN CARLOS ROQUE', 'SV-128', 'VETILLAS SRL.', '', 'PLATA 248.96 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34673', 'U-257', ' - PLATA', '1193', 'GRUPO DONALDSON ', '1036', 'SEÑOR DE MANQUIRI', '', 'PLATA 124.47 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34674', 'U-258', ' - PLATA', '1194', 'GRUPO DONALDSON ', '1037', 'SEÑOR DE MANQUIRI', '', 'PLATA 422.43 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34675', 'U-259', ' - PLATA', '1195', 'GRUPO DONALDSON ', '1035', 'SEÑOR DE MANQUIRI', '', 'PLATA 51.01 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34676', 'U-260', ' - ESTAÑO', '1196', 'OSCAR NAVARRO', '1650', '\"SAN JUAN \"\"J.A.M.\"\"\"', '', 'ESTAÑO 34.53 % Sn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34677', 'U-261', ' - ZINC - PLATA', '1197', 'TEODORO CHOQUE TOLA', 'MRB-2294', 'RODRIGUEZ S.R.L.', '', 'ZINC 6.68 % Zn|PLATA 1.85 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34678', 'U-262', ' - ZINC - PLOMO', '1198', 'RILIAN MOREIRA', 'A-ZNA-23011', 'AMACER S.R.L.', '', 'ZINC 14.66 % Zn|PLOMO 1.02 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34679', 'U-263', ' - ZINC', '1199', 'MARIO TACURI', 'CS-366', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 7.35 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34680', 'U-264', ' - ZINC', '1200', 'MARIO TACURI', 'CS-367', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.45 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34681', 'U-265', ' - ZINC', '1201', 'MARIO TACURI', 'CS-368', '\"MULTISERVICIOS \"\"SJ\"\"\"', '', 'ZINC 6.31 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34682', 'U-266', ' - PLATA', '1202', 'ANDRES VILLCA', 'C23-01-86', 'VETILLAS S.R.L.', '', 'PLATA 3.91 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34683', 'U-267', ' - ZINC - PLATA', '1203', 'JUAN CARLOS QUIRROZ', 'C23-01-88', 'VETILLAS S.R.L.', '', 'ZINC 9.86 % Zn|PLATA 1.28 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34684', 'U-268', ' - ZINC - PLATA - PLOMO', '1204', 'CRISPIN QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 7.11 % Zn|PLATA 1.71 DM Ag|PLOMO 0.64 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34685', 'U-269', ' - ZINC', '1205', 'ALFREDO QUISPE', '2090', 'EM&CON BOMBORI S.R.L.', '', 'ZINC 5.24 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34686', 'U-270', ' - ZINC', '1206', 'ESEQUIEL RUIZ', 'LM-2181', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 16.98 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34687', 'U-271', ' - ZINC - PLATA', '1207', 'SAMUEL MAMANI', 'LM-2176', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 4.95 % Zn|PLATA 1.07 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34688', 'U-272', ' - ZINC', '1208', 'ISIDRO CRUZ', 'LM-2184', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 6.23 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34689', 'U-273', ' - ZINC - PLOMO', '1209', 'SATURNINO LOPEZ', 'B.C. 0.36', 'SAN JORGE', '', 'ZINC 9.01 % Zn|PLOMO 5.67 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34690', 'U-274', ' - ZINC', '1210', 'SATURNINO LOPEZ', 'B.C.035', 'SAN JORGE', '', 'ZINC 7.18 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34691', 'U-275', ' - ZINC - PLOMO', '1211', 'DANIEL CARMONA', 'LM-2178', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.03 % Zn|PLOMO 7.06 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34692', 'U-276', ' - ZINC', '1212', 'FLORIAN CRUZ', 'LM-2179', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.11 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34693', 'U-277', ' - PLATA', '1213', 'VICTOR ', 'M.E. 20-01', 'VIRGEN DE URKUPIÑA', '', 'PLATA 2963.21 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34694', 'U-278', ' - ZINC - PLATA', '1214', 'DESIDERIA MAMANI', 'L-011-KL23', 'ELIKAIROS S.R.L.', '', 'ZINC 34.71 % Zn|PLATA 1.87 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34695', 'U-279', ' - PLATA', '1215', 'LORENZO ARIAS', 'L:710', 'A & M', '', 'PLATA 1502.32 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34696', 'U-280', ' - PLATA', '1216', 'LORENZO ARIAS', 'L:708', 'A & M', '', 'PLATA 496.59 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34697', 'U-281', ' - PLATA', '1217', 'LORENZO ARIAS', 'L:709', 'A & M', '', 'PLATA 1907.12 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34698', 'U-282', ' - PLATA', '1218', 'JUAN CARLOS ROQUE', 'SV-131', 'VETILLAS S.R.L.', '', 'PLATA 459.04 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34699', 'U-283', ' - PLATA', '1219', 'JULIAN MANCILLA', '1488', 'ESTIRPE DE PLATA', '', 'PLATA 212.82 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34700', 'U-284', ' - PLATA', '1220', 'JULIAN MANCILLA', '1487', 'ESTIRPE DE PLATA', '', 'PLATA 1055.79 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34701', 'U-285', ' - PLATA', '1221', 'JHOJAN ANTONY ', '82', 'SEÑOR DE SANTIAGO', '', 'PLATA 35.46 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34702', 'U-286', ' - PLATA', '1222', 'JUAN CARLOS ROQUE', 'SV-132', 'VETILLAS S.R.L.', '', 'PLATA 1736.01 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34703', 'U-287', ' - PLATA', '1223', 'ELVIS SUYO', '73', 'SAN LUIS', '', 'PLATA 285.85 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34704', 'U-288', ' - PLATA', '1224', 'EDDY AYAVIRI', 'E-00153', 'S/P', '', 'PLATA 76.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34705', 'U-289', ' - PLATA', '1225', 'SENON QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34706', 'U-290', ' - PLATA', '1226', 'MARTIN MENACHO', '2060', 'M. PMIN', '', 'PLATA 942.25 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34707', 'U-291', ' - PLATA', '1227', 'FRANCISCO SANTOS', 'EZN-172', 'EMIGON S.R.L.', '', 'PLATA 47.79 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34708', 'U-292', ' - PLATA', '1228', 'JHOJAN ANTONY ', '83', 'SEÑOR DE SANTIAGO', '', 'PLATA 16.62 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34709', 'U-293', ' - PLATA', '1229', 'MARTIN MENACHO', '2058', 'M. PMIN', '', 'PLATA 415.11 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34710', 'U-294', ' - PLATA', '1230', 'MARTIN MENACHO', '2059', 'M. PMIN', '', 'PLATA 989.16 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34711', 'U-295', ' - PLATA', '1231', 'ADOLFO MENACHO', '2057', 'M. PMIN', '', 'PLATA 133.58 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34712', 'U-296', ' - PLATA', '1232', 'GONZALO SALVATIERA', '359', 'R-METALS', '', 'PLATA 243.87 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34713', 'U-297', ' - PLATA', '1233', 'GONZALO SALVATIERRA', '360', 'R-METALS', '', 'PLATA 71.86 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34714', 'U-298', ' - PLATA', '1234', 'OMAR GUTIERREZ', 'R-17', 'BOLIVAR', '', 'PLATA 8.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34715', 'U-299', ' - PLATA', '1235', 'TEOFILO QUIROGA', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 9.50 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34716', 'U-300', ' - ZINC - PLATA - PLOMO', '1236', 'ERMES RUDY FLORES F.', '23L03575', 'LAMBOL S.A.', '', 'ZINC 12.89 % Zn|PLATA 2.45 DM Ag|PLOMO 3.70 % Pb|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34717', 'U-301', ' - PLATA', '1237', 'NELSON CALLO', 'MUESTRA ESPECIAL', 'S/P', '', 'PLATA 2.89 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34718', 'U-302', ' - ZINC', '1238', 'RENE CARRASCO', '23L03554', 'LAMBOL S.A.', '', 'ZINC 6.80 % Zn|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34719', 'U-303', ' - ZINC - PLATA', '1239', 'TEOFILO QUIROGA', '1', 'ASMIMBOL CRUZ S.R.L.', '', 'ZINC 7.55 % Zn|PLATA 2.20 DM Ag|', '2023-01-17');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34720', 'U-304', ' - PLATA', '1243', 'MIGUEL MANCILLA', '1489', 'ESTIRPE DE PLATA', '', 'PLATA 496.59 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34721', 'U-305', ' - ZINC - PLATA - PLOMO', '1244', 'RICARDO QUISPE', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 5.50 % Zn|PLATA 1.76 DM Ag|PLOMO 2.10 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34722', 'U-306', ' - ZINC - PLATA', '1245', 'JOSE MIGUEL RAMOS', 'VAL3-316', 'MISERICORDIA S.R.L.', '', 'ZINC 15.25 % Zn|PLATA 0.86 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34723', 'U-307', ' - ZINC - PLATA', '1246', 'BEYMAR SUARES', 'VAL3-318', 'MISERICORDIA S.R.L.', '', 'ZINC 9.03 % Zn|PLATA 1.32 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34724', 'U-308', ' - PLATA - PLOMO', '1247', 'RAUL IBARRA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 11.30 DM Ag|PLOMO 52.39 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34725', 'U-309', ' - ZINC', '1248', 'LAMBOL MINA CONDOR ', '23L03613', 'LAMBOL S.A.', '', 'ZINC 5.55 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34726', 'U-310', ' - ZINC', '1249', 'CELSO SOLIZ', '29', 'RIO DE PLATA', '', 'ZINC 9.78 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34727', 'U-311', ' - ZINC', '1250', 'IGOR GOMEZ', '62', 'RIO DE PLATA', '', 'ZINC 6.88 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34728', 'U-312', ' - ZINC', '1251', 'CELSO SOLIZ', '50', 'RIO DE PLATA', '', 'ZINC 11.41 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34729', 'U-313', ' - ZINC - PLATA - PLOMO', '1252', 'EULOGIO ARICOMA', '5158', 'ALDEEXPORMIN', '', 'ZINC 23.89 % Zn|PLATA 8.08 DM Ag|PLOMO 10.30 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34730', 'U-314', ' - ZINC - PLATA - PLOMO', '1253', 'GONZALO HUARACHI', '5156', 'ALDEEXPORMIN', '', 'ZINC 26.06 % Zn|PLATA 8.60 DM Ag|PLOMO 6.40 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34731', 'U-315', ' - ZINC - PLATA - PLOMO', '1254', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0602-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.89 % Zn|PLATA 4.40 DM Ag|PLOMO 5.55 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34732', 'U-316', ' - ZINC - PLATA - PLOMO', '1255', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0611-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 4.77 % Zn|PLATA 3.46 DM Ag|PLOMO 7.40 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34733', 'U-317', ' - ZINC - PLATA - PLOMO', '1256', 'MARCO ISAC ANAGUA ASTORAIQUE', 'CC-0613-23-R', 'COOP.MIN.PORCO R.L.', '', 'ZINC 6.19 % Zn|PLATA 4.70 DM Ag|PLOMO 5.15 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34734', 'U-318', ' - ZINC', '1257', 'OSCAR VILLCA', 'COLA', 'S/P', '', 'ZINC 0.68 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34735', 'U-319', ' - PLATA', '1258', 'OSCAR VILLCA', 'CONCENTRADO', 'S/P', '', 'PLATA 60.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34736', 'U-320', ' - PLATA', '1259', 'MINEXA S.R.L. ', 'MMNEE', 'MINEXA S.R.L.', '', 'PLATA 583.88 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34737', 'U-321', ' - PLATA', '1260', 'RENE TAPIA', 'SV-135', 'VETILLAS SRL.', '', 'PLATA 22.84 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34738', 'U-322', ' - PLATA', '1261', 'JHON FLORES', '757', 'FENIX', '', 'PLATA 260.55 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34739', 'U-323', ' - PLATA', '1262', 'JHON FLORES', '758', 'FENIX', '', 'PLATA 771.11 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34740', 'U-324', ' - PLATA', '1263', 'JUAN ISLA', '64', 'EL MAJESTUOSO', '', 'PLATA 22.84 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34741', 'U-325', ' - PLATA', '1264', 'RICHAR CUPARA', '22033', 'MINEXA S.R.L.', '', 'PLATA 585.50 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34742', 'U-326', ' - PLATA', '1265', 'LUIS DELGADO', 'DRC-16', 'ANGELES', '', 'PLATA 249.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34743', 'U-327', ' - PLATA', '1266', 'CELSO CRUZ GUTIERREZ', '3876', 'UNIFICADA POTOSI R.L.', '', 'PLATA 12.46 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34744', 'U-328', ' - PLATA', '1267', 'CARLOS FLORES', '6910', 'COEXMIN S.R.L.', '', 'PLATA 240.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34745', 'U-329', ' - PLATA', '1268', 'SINFORIANO PUMA', '5693', 'EMCON S.R.L.', '', 'PLATA 56.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34746', 'U-330', ' - PLATA', '1269', 'ABELIÑO GUTIERREZ', '3090', 'CKACHAS S.R.L.', '', 'PLATA 205.17 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34747', 'U-331', ' - PLATA', '1270', 'ABELINO GUTIERREZ', '3095', 'CKACHAS S.R.L.', '', 'PLATA 365.18 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34748', 'U-332', ' - ESTAÑO', '1271', 'JORGE FERNANDEZ', '1653', 'SAN JUAN J.A.M.', '', 'ESTAÑO 22.39 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34749', 'U-333', ' - PLATA', '1272', 'JUAN TACURI', '01-TACURI', 'FENIX', '', 'PLATA 4.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34750', 'U-334', ' - ZINC - PLATA', '1273', 'WILSON O.', '12', 'S/P', '', 'ZINC 12.05 % Zn|PLATA 1.80 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34751', 'U-335', ' - ZINC - PLATA', '1274', 'WILSON O.', '11', 'S/P', '', 'ZINC 13.56 % Zn|PLATA 2.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34752', 'U-336', ' - PLATA', '1275', 'CRISTIAN CALDERON', 'CC-2502', 'S/P', '', 'PLATA 2.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34753', 'U-337', ' - ZINC', '1276', 'ESEGUIEL RUIZ', 'LM-2191', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.05 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34754', 'U-338', ' - ZINC - PLATA - PLOMO', '1277', 'COOP. HUAYNA PORCO', 'LM-2170', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 13.89 % Zn|PLATA 2.30 DM Ag|PLOMO 7.70 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34755', 'U-339', ' - ZINC - PLATA', '1278', 'WALTER RAMOS', 'MUESTRA ESPECIAL', 'S/P', '', 'ZINC 20.21 % Zn|PLATA 1.65 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34756', 'U-340', ' - ZINC - PLATA', '1279', 'ROLANDO COPA', 'MUESTRA ESPECIAL ', 'S/P', '', 'ZINC 51.89 % Zn|PLATA 2.03 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34757', 'U-341', ' - PLATA', '1280', 'JORGE CRUZ', 'SPA-AG-40', 'SINCHI PUKARA S.R.L.', '', 'PLATA 3.85 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34758', 'U-342', ' - ZINC', '1281', 'LEANDRO SUYO', '1907-23', 'IMSUR', '', 'ZINC 2.50 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34759', 'U-343', ' - PLATA', '1282', 'JHONNY MAMANI', 'PBX1', 'FENIX', '', 'PLATA 8.65 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34760', 'U-344', ' - PLATA', '1283', 'JHONY MAMANI', '02-R', 'FENIX', '', 'PLATA 1.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34761', 'U-345', ' - ZINC - PLATA - PLOMO', '1284', 'PLACIDO COPA MARTINEZ', 'C-10287', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 5.70 % Zn|PLATA 1.40 DM Ag|PLOMO 0.45 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34762', 'U-346', ' - ZINC', '1285', 'GONZALO LIMACHI', 'C-10291', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 8.55 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34763', 'U-347', ' - ZINC - PLATA', '1286', 'ALVARO SAAVEDRA', 'C-10289', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 4.10 % Zn|PLATA 1.85 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34764', 'U-348', ' - PLATA', '1287', 'LUIS CRUZ', 'C-0161', 'REDMETALS R.R.L.', '', 'PLATA 3.10 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34765', 'U-349', ' - PLATA', '1288', 'LUIS CRUZ', 'C-0160', 'REDMETALS R.R.L.', '', 'PLATA 3.35 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34766', 'U-350', ' - ZINC - PLATA', '1289', 'ALVARO SAAVEDRA', 'C-10288', 'PUENTE DE PLATA S.R.L.', '', 'ZINC 3.30 % Zn|PLATA 1.66 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34767', 'U-351', ' - PLATA', '1290', 'JORGE CRUZ', '5', 'ASMIMBOL CRUZ S.R.L.', '', 'PLATA 4.25 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34768', 'U-352', ' - PLATA', '1291', 'ALEXANDER CHIPANA', 'M-109', 'CAMPO VERDE', '', 'PLATA 3.20 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34769', 'U-353', ' - ZINC', '1292', 'FLORENCIO CONDORI', 'LM-2189', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 11.58 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34770', 'U-354', ' - ZINC - PLATA', '1293', 'JORGE LUIS COPACABA CRUZ', 'MRB-2122', 'RODRIGUEZJM S.R.L.', '', 'ZINC 18.88 % Zn|PLATA 8.45 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34771', 'U-355', ' - ZINC', '1294', 'DAVID ALVAREZ', 'LM-2201', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 12.05 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34772', 'U-356', ' - ZINC - PLATA', '1295', 'CIRILO LUNASCO CANSECO', 'CV-730', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 19.60 % Zn|PLATA 1.07 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34773', 'U-357', ' - ZINC - PLATA', '1296', 'CIRILO LUNASCO CANSECO', 'CV-732', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 25.41 % Zn|PLATA 1.11 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34774', 'U-358', ' - ZINC - PLATA', '1297', 'CIRILO LUNASCO CANSECO', 'CV-726', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 21.89 % Zn|PLATA 1.05 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34775', 'U-359', ' - ZINC', '1298', 'DAVID ALVAREZ', 'LM-2202', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 10.12 % Zn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34776', 'U-360', ' - ZINC - PLATA', '1299', 'CIRILO LUNASCO CANSECO', 'CV-734', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 18.67 % Zn|PLATA 1.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34777', 'U-361', ' - ZINC - PLATA', '1300', 'CIRILO LUNASCO CANSECO', 'CV-731', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 27.18 % Zn|PLATA 1.13 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34778', 'U-362', ' - ZINC - PLATA', '1301', 'CIRILO LUNASCO CANSECO', 'CV-728', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 20.04 % Zn|PLATA 0.89 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34779', 'U-363', ' - ZINC - PLATA', '1302', 'CIRILO LUNASCO CANSECO', 'CV-727', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 29.14 % Zn|PLATA 1.31 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34780', 'U-364', ' - ZINC - PLATA', '1303', 'SERAPIO PORTILLO SERRANO', 'CC-0626/23', 'COOP.MIN. PORCO RL.', '', 'ZINC 9.70 % Zn|PLATA 1.08 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34781', 'U-365', ' - ESTAÑO', '1304', 'C.T.S. ', 'MUESTRA ESPECIAL -1', 'S/P', '', 'ESTAÑO 1.04 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34782', 'U-366', ' - ESTAÑO', '1305', 'C.T.S. ', 'MUESTRA ESPECIAL -2', 'S/P', '', 'ESTAÑO 0.41 % Sn|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34783', 'U-367', ' - ZINC - PLATA - HUMEDAD', '1306', 'GREGORIO CHOQUE', 'FM-13/23', 'VIRGEN DE COTOCA S.R.L.', '', 'ZINC 33.58 % Zn|PLATA 6.11 DM Ag|HUMEDAD 8.89 % H2O|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34784', 'U-368', ' - PLATA', '1307', 'TEODORO RAMIREZ', 'L-AG/0396', 'ISMAR S.R.L.', '', 'PLATA 134.68 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34785', 'U-369', ' - PLATA - PLOMO', '1308', 'NELSON CALLA', 'MUESTRA ESPECIAL ', 'S/P', '', 'PLATA 0.89 DM Ag|PLOMO 30.11 % Pb|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34786', 'U-370', ' - PLATA', '1309', 'JANNETH IGLESIAS', 'SV-137', 'VETILLAS SRL.', '', 'PLATA 245.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34787', 'U-371', ' - PLATA - HUMEDAD', '1310', 'GREGORIO CHOQUE', '1', 'VIRGEN DE COTOCA S.R.L.', '', 'PLATA 33.64 DM Ag|HUMEDAD 7.90 % H2O|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34788', 'U-372', ' - PLATA', '1311', 'ALBERTO GALLARDO', '5695', 'EMCON S.R.L.', '', 'PLATA 120.17 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34789', 'U-373', ' - PLATA', '1312', 'GREGORIO CHOQUE', '1580', 'PUENTE DE PLATA S.R.L.', '', 'PLATA 44.15 DM Ag|', '2023-01-18');
INSERT INTO `certificados` (`id`, `codigo`, `analisis`, `n_certificado`, `pertenencia`, `lote`, `procedencia`, `observacion`, `mineral`, `fecha`) VALUES ('34790', 'SM-000003GM-4552', ' - ZINC - PLATA', '1314', 'PARTICULAR ', 'GM-4552', 'VETILLAS', '', 'ZINC 12.00 % Zn|PLATA 2.00 DM Ag|', '2023-12-20');


#
# TABLE STRUCTURE FOR: clientes_precios
#

DROP TABLE IF EXISTS `clientes_precios`;

CREATE TABLE `clientes_precios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_persona` int(11) NOT NULL,
  `id_elementos` int(11) NOT NULL,
  `costo` decimal(7,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_persona` (`id_persona`),
  KEY `id_elementos` (`id_elementos`),
  CONSTRAINT `clientes_precios_ibfk_1` FOREIGN KEY (`id_persona`) REFERENCES `persona` (`persona_id`),
  CONSTRAINT `clientes_precios_ibfk_2` FOREIGN KEY (`id_elementos`) REFERENCES `mineral` (`mineral_id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('1', '4', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('2', '4', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('3', '4', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('4', '4', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('5', '5', '1', '20.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('6', '5', '2', '20.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('7', '5', '3', '20.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('8', '5', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('9', '6', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('10', '6', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('11', '6', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('12', '6', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('13', '6', '5', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('14', '6', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('15', '6', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('16', '6', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('17', '6', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('18', '7', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('19', '7', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('20', '7', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('21', '7', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('22', '7', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('23', '7', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('24', '7', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('25', '7', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('26', '7', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('27', '8', '1', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('28', '8', '2', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('29', '8', '3', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('30', '8', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('31', '8', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('32', '8', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('33', '8', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('34', '8', '8', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('35', '8', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('36', '9', '1', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('37', '9', '2', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('38', '9', '3', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('39', '9', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('40', '9', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('41', '9', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('42', '9', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('43', '9', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('44', '9', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('45', '10', '1', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('46', '10', '2', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('47', '10', '3', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('48', '10', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('49', '10', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('50', '10', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('51', '10', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('52', '10', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('53', '10', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('54', '11', '1', '20.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('55', '11', '2', '20.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('56', '11', '3', '20.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('57', '11', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('58', '11', '5', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('59', '11', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('60', '11', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('61', '11', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('62', '11', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('63', '12', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('64', '12', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('65', '12', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('66', '12', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('67', '12', '5', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('68', '12', '6', '80.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('69', '12', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('70', '12', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('71', '12', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('72', '13', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('73', '13', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('74', '13', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('75', '13', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('76', '13', '5', '50.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('77', '13', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('78', '13', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('79', '13', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('80', '13', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('81', '14', '1', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('82', '14', '2', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('83', '14', '3', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('84', '14', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('85', '14', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('86', '14', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('87', '14', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('88', '14', '8', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('89', '14', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('90', '15', '1', '35.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('91', '15', '2', '35.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('92', '15', '3', '35.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('93', '15', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('94', '15', '5', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('95', '15', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('96', '15', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('97', '15', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('98', '15', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('99', '16', '1', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('100', '16', '2', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('101', '16', '3', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('102', '16', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('103', '16', '5', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('104', '16', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('105', '16', '7', '60.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('106', '16', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('107', '16', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('108', '17', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('109', '17', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('110', '17', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('111', '17', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('112', '17', '5', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('113', '17', '6', '80.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('114', '17', '7', '60.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('115', '17', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('116', '17', '9', '60.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('117', '18', '1', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('118', '18', '2', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('119', '18', '3', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('120', '18', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('121', '18', '5', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('122', '18', '6', '80.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('123', '18', '7', '60.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('124', '18', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('125', '18', '9', '60.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('126', '19', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('127', '19', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('128', '19', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('129', '19', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('130', '19', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('131', '19', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('132', '19', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('133', '19', '8', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('134', '19', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('135', '20', '1', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('136', '20', '2', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('137', '20', '3', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('138', '20', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('139', '20', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('140', '20', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('141', '20', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('142', '20', '8', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('143', '20', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('144', '21', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('145', '21', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('146', '21', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('147', '21', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('148', '21', '5', '35.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('149', '21', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('150', '21', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('151', '21', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('152', '21', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('153', '22', '1', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('154', '22', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('155', '22', '3', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('156', '22', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('157', '22', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('158', '22', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('159', '22', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('160', '22', '8', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('161', '22', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('162', '23', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('163', '23', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('164', '23', '3', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('165', '23', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('166', '23', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('167', '23', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('168', '23', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('169', '23', '8', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('170', '23', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('171', '28', '1', '35.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('172', '28', '2', '35.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('173', '28', '3', '35.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('174', '28', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('175', '28', '5', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('176', '28', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('177', '28', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('178', '28', '8', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('179', '28', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('180', '29', '1', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('181', '29', '2', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('182', '29', '3', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('183', '29', '4', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('184', '29', '5', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('185', '29', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('186', '29', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('187', '29', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('188', '29', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('189', '30', '1', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('190', '30', '2', '25.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('191', '30', '3', '30.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('192', '30', '4', '40.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('193', '30', '5', '50.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('194', '30', '6', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('195', '30', '7', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('196', '30', '8', '10.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('197', '30', '9', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('198', '30', '10', '0.00');
INSERT INTO `clientes_precios` (`id`, `id_persona`, `id_elementos`, `costo`) VALUES ('199', '22', '10', '60.00');


#
# TABLE STRUCTURE FOR: despacho
#

DROP TABLE IF EXISTS `despacho`;

CREATE TABLE `despacho` (
  `despacho_id` int(11) NOT NULL AUTO_INCREMENT,
  `id_recepcion` int(11) NOT NULL,
  `n_certificado` varchar(20) NOT NULL,
  `observacion` varchar(255) NOT NULL,
  `fecha_emision` date NOT NULL,
  `id_usuario` int(11) NOT NULL,
  `estado_despacho` varchar(2) NOT NULL DEFAULT 'SI',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`despacho_id`),
  KEY `id_usuario` (`id_usuario`),
  KEY `id_recepcion` (`id_recepcion`),
  CONSTRAINT `despacho_ibfk_1` FOREIGN KEY (`id_recepcion`) REFERENCES `recepcion` (`recepcion_id`),
  CONSTRAINT `despacho_ibfk_2` FOREIGN KEY (`id_usuario`) REFERENCES `usuario` (`usuario_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9404 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('72', '85', '2028-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-15', '1', 'SI', '2024-04-15 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('73', '80', '2028-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-28', '1', 'SI', '2024-04-28 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('74', '81', '2028-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-28', '1', 'SI', '2024-04-28 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('75', '82', '2028-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-28', '1', 'SI', '2024-04-28 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('76', '83', '2028-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-28', '1', 'SI', '2024-04-28 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('77', '84', '2028-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-28', '1', 'SI', '2024-04-28 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('78', '85', '2028-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-28', '1', 'SI', '2024-04-28 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('79', '86', '2029-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-28', '2', 'SI', '2024-04-28 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('80', '87', '2030-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('81', '89', '2032-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('82', '90', '2033-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('83', '91', '2034-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('84', '92', '2035-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('85', '94', '2037-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('86', '95', '2038-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('87', '96', '2038-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('88', '97', '2038-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('89', '98', '2038-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('90', '88', '2031-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-30', '1', 'SI', '2024-04-30 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('91', '100', '2040-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('92', '101', '2041-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('93', '102', '2041-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('94', '103', '2041-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('95', '104', '2042-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('96', '105', '2042-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('97', '106', '2042-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('98', '107', '2042-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('99', '108', '2042-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('100', '109', '2042-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('101', '110', '2042-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('102', '111', '2043-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('103', '112', '2044-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('104', '113', '2045-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('105', '114', '2046-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('106', '115', '2046-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('107', '116', '2046-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('108', '117', '2046-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('109', '118', '2047-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('110', '120', '2049-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('111', '119', '2048-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-29', '1', 'SI', '2024-04-29 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('112', '122', '2051-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('113', '125', '2054-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('114', '126', '2054-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('115', '129', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('116', '130', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('117', '131', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('118', '132', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('119', '133', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('120', '134', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('121', '135', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('122', '136', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('123', '137', '2056-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '2', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('124', '140', '15', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('125', '145', '20', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('126', '144', '19', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('127', '143', '18', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('128', '142', '17', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('129', '141', '16', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('130', '154', '29', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('131', '155', '29', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('132', '156', '30', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('133', '157', '31', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('134', '158', '31', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('135', '159', '31', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('136', '153', '28', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('137', '152', '27', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('138', '151', '26', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('139', '150', '25', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('140', '149', '24', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('141', '148', '23', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('142', '147', '22', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('143', '146', '21', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('144', '160', '32', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('145', '161', '32', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('146', '162', '32', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('147', '163', '32', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('148', '164', '32', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('149', '165', '32', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-02', '1', 'SI', '2024-05-02 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('150', '166', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('151', '167', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('152', '168', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('153', '169', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('154', '170', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('155', '171', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('156', '172', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('157', '173', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('158', '174', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('159', '175', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('160', '176', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('161', '177', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('162', '178', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('163', '179', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('164', '180', '33', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('165', '181', '34', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('166', '182', '34', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('167', '183', '34', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('168', '184', '34', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('169', '189', '36', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('170', '190', '36', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('171', '185', '35', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('172', '186', '35', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('173', '187', '35', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('174', '188', '35', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('175', '191', '37', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('176', '192', '37', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('177', '193', '37', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('178', '194', '37', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('179', '195', '38', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('180', '196', '39', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('181', '199', '41', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('182', '200', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('183', '201', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('184', '202', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('185', '203', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('186', '204', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('187', '205', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('188', '206', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('189', '207', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('190', '208', '42', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('191', '197', '40', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('192', '198', '40', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('193', '209', '43', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('194', '210', '44', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('195', '212', '46', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('196', '93', '2036-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('197', '99', '2039-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('198', '121', '2050-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('199', '123', '2052-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('200', '124', '2053-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('201', '127', '2055-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('202', '128', '2055-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('203', '138', '2057-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('204', '139', '2057-A', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '2', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('205', '216', '50', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('206', '218', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('207', '219', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('208', '220', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('209', '221', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('210', '222', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('211', '223', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('212', '224', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('213', '225', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('214', '226', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('215', '227', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('216', '228', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('217', '229', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('218', '230', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('219', '231', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('220', '232', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('221', '233', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('222', '234', '52', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('223', '235', '53', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('224', '236', '54', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('225', '237', '55', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('226', '243', '61', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('227', '215', '49', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('228', '245', '63', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('229', '211', '45', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('230', '213', '47', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('231', '248', '66', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('232', '249', '66', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('233', '250', '66', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('234', '251', '67', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('235', '252', '67', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('236', '253', '67', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('237', '256', '69', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('238', '257', '69', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('239', '258', '69', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('240', '259', '69', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('241', '260', '69', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('242', '261', '70', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('243', '262', '70', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('244', '263', '70', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('245', '264', '70', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('246', '265', '70', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('247', '266', '70', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('248', '267', '70', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('249', '268', '70', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('250', '270', '72', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('251', '271', '73', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('252', '272', '74', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('253', '273', '74', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('254', '274', '74', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('255', '275', '74', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('256', '276', '74', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('257', '277', '74', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('258', '278', '74', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('259', '279', '75', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('260', '281', '77', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('261', '282', '77', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '2', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('262', '283', '78', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('263', '284', '78', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('264', '285', '78', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('265', '286', '78', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('266', '287', '78', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('267', '288', '78', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-03', '1', 'SI', '2024-05-03 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('268', '238', '56', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('269', '247', '65', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('270', '290', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('271', '291', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('272', '292', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('273', '293', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('274', '294', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('275', '295', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('276', '296', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('277', '297', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('278', '298', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('279', '299', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('280', '300', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('281', '301', '80', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('282', '302', '81', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('283', '242', '60', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('284', '244', '62', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('285', '239', '57', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('286', '241', '59', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('287', '269', '71', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('288', '308', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('289', '309', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('290', '310', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('291', '311', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('292', '312', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('293', '313', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('294', '314', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('295', '315', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('296', '316', '83', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('297', '303', '82', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('298', '304', '82', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('299', '305', '82', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('300', '306', '82', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('301', '307', '82', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('302', '317', '84', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('303', '318', '85', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('304', '280', '76', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('305', '320', '87', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('306', '246', '64', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('307', '321', '88', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('308', '322', '88', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('309', '323', '88', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('310', '324', '88', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('311', '325', '89', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('312', '326', '89', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('313', '327', '90', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('314', '328', '91', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('315', '329', '92', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('316', '330', '93', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('317', '333', '96', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('318', '289', '79', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('319', '343', '100', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('320', '344', '100', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('321', '345', '100', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('322', '346', '100', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('323', '336', '98', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('324', '337', '98', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('325', '338', '98', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('326', '339', '98', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('327', '340', '98', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('328', '341', '98', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-04', '1', 'SI', '2024-05-04 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('329', '347', '101', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-05', '1', 'SI', '2024-05-05 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('330', '348', '101', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-05', '1', 'SI', '2024-05-05 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('331', '349', '101', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-05', '1', 'SI', '2024-05-05 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('332', '350', '101', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-05', '1', 'SI', '2024-05-05 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('333', '351', '101', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-05', '1', 'SI', '2024-05-05 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('334', '352', '101', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-05', '1', 'SI', '2024-05-05 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('335', '353', '102', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('336', '356', '104', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('337', '357', '105', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('338', '358', '105', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('339', '359', '106', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('340', '362', '109', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('341', '361', '108', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('342', '360', '107', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('343', '331', '94', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('344', '363', '110', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('345', '364', '110', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('346', '365', '110', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('347', '366', '110', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('348', '367', '111', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('349', '368', '111', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('350', '371', '114', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('351', '372', '114', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('352', '354', '103', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('353', '355', '103', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('354', '373', '115', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('355', '374', '115', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('356', '254', '68', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('357', '255', '68', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('358', '370', '113', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('359', '381', '121', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('360', '382', '121', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('361', '383', '121', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('362', '384', '121', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('363', '385', '121', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('364', '386', '121', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-06', '1', 'SI', '2024-05-06 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('365', '387', '122', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('366', '388', '122', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('367', '389', '122', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('368', '390', '122', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('369', '391', '122', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('370', '334', '97', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('371', '335', '97', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('372', '395', '126', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('373', '396', '126', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('374', '376', '117', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('375', '397', '127', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('376', '379', '119', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('377', '400', '130', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('378', '401', '131', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '2', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('379', '407', '136', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('380', '408', '136', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('381', '409', '136', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('382', '410', '136', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('383', '413', '138', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('384', '414', '138', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('385', '415', '138', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('386', '416', '138', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('387', '417', '138', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('388', '418', '138', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-07', '1', 'SI', '2024-05-07 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('389', '419', '139', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('390', '420', '139', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('391', '421', '139', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('392', '422', '139', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('393', '423', '139', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('394', '424', '139', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('395', '425', '140', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('396', '426', '141', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('397', '427', '141', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('398', '430', '143', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('399', '431', '143', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('400', '432', '143', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('401', '433', '143', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('402', '404', '134', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('403', '405', '134', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('404', '394', '125', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('405', '435', '145', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('406', '403', '133', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('407', '434', '144', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('408', '399', '129', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('409', '437', '147', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('410', '398', '128', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('411', '439', '149', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '2', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('412', '440', '150', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('413', '441', '150', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('414', '442', '150', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('415', '443', '150', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('416', '444', '150', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('417', '445', '150', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('418', '448', '153', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('419', '447', '152', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('420', '446', '151', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('421', '450', '155', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('422', '380', '120', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('423', '428', '142', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('424', '429', '142', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('425', '454', '157', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('426', '455', '157', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('427', '456', '157', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('428', '457', '157', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('429', '451', '156', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('430', '452', '156', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('431', '453', '156', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-08', '1', 'SI', '2024-05-08 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('432', '392', '123', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('433', '406', '135', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('434', '369', '112', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('435', '458', '158', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('436', '449', '154', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('437', '459', '159', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('438', '460', '159', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('439', '461', '159', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('440', '463', '161', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('441', '464', '162', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('442', '465', '163', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('443', '436', '146', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('444', '481', '172', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('445', '482', '172', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('446', '483', '172', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('447', '484', '172', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('448', '486', '174', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('449', '466', '164-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('450', '467', '164-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('451', '488', '176', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('452', '489', '176', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('453', '490', '176', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('454', '491', '176', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('455', '492', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('456', '493', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('457', '494', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('458', '495', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('459', '496', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('460', '497', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('461', '498', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('462', '499', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('463', '500', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('464', '501', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('465', '502', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('466', '503', '177', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('467', '505', '179', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('468', '506', '180', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-30', '1', 'SI', '2024-04-30 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('469', '507', '180', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-30', '1', 'SI', '2024-04-30 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('470', '508', '180', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-30', '1', 'SI', '2024-04-30 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('471', '509', '180', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-04-30', '1', 'SI', '2024-04-30 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('472', '510', '181', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('473', '511', '181', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('474', '512', '181', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('475', '513', '181', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('476', '515', '183', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('477', '516', '183', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('478', '517', '183', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('479', '518', '183', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('480', '519', '184', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('481', '520', '184', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('482', '521', '184', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('483', '522', '184', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-09', '1', 'SI', '2024-05-09 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('484', '523', '185', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('485', '524', '185', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('486', '525', '185', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('487', '527', '187', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('488', '530', '190', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('489', '531', '190', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('490', '532', '190', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('491', '533', '190', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('492', '534', '190', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('493', '535', '190', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('494', '536', '191', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('495', '537', '191', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('496', '538', '191', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('497', '468', '165', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('498', '393', '124', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('499', '539', '192', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('500', '540', '192', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('501', '541', '193', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('502', '542', '194', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('503', '543', '194', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('504', '544', '195', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('505', '545', '196', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('506', '546', '196', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('507', '485', '173', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('508', '547', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('509', '548', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('510', '549', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('511', '550', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('512', '551', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('513', '552', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('514', '553', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('515', '554', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('516', '555', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('517', '556', '197', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-10', '1', 'SI', '2024-05-10 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('518', '557', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('519', '558', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('520', '559', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('521', '560', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('522', '561', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('523', '562', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('524', '563', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('525', '564', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('526', '565', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('527', '566', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('528', '567', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('529', '568', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('530', '569', '198', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('531', '514', '182', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('532', '570', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('533', '571', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('534', '572', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('535', '573', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('536', '574', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('537', '575', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('538', '576', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('539', '577', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('540', '578', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('541', '579', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('542', '580', '199', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('543', '529', '189', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('544', '582', '201', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('545', '469', '166-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('546', '470', '166-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('547', '583', '202', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('548', '584', '203', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('549', '585', '204', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('550', '591', '209', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('551', '592', '209', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('552', '593', '209', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('553', '594', '209', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('554', '595', '209', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('555', '596', '209', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('556', '602', '214', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('557', '603', '214', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('558', '604', '214', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('559', '605', '214', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('560', '606', '214', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('561', '611', '218', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('562', '587', '206', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('563', '589', '208-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('564', '590', '208-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('565', '612', '219', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('566', '613', '219', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('567', '614', '219', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('568', '615', '219', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('569', '616', '219', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('570', '617', '219', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('571', '618', '219', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('572', '581', '200', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('573', '504', '178', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('574', '619', '220', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('575', '620', '220', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('576', '621', '220', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('577', '622', '220', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('578', '623', '220', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('579', '624', '220', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('580', '625', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('581', '626', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('582', '627', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('583', '628', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('584', '629', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('585', '630', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('586', '631', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('587', '632', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('588', '633', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('589', '634', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('590', '635', '221', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('591', '638', '224', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('592', '637', '223', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('593', '636', '222', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('594', '639', '225', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('595', '640', '226', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('596', '641', '226', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('597', '642', '226', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('598', '643', '226', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('599', '644', '226', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('600', '645', '226', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('601', '646', '226', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('602', '647', '226', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('603', '648', '227', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('604', '649', '228', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('605', '650', '229', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('606', '651', '229', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '1', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('607', '652', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('608', '653', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('609', '654', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('610', '655', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('611', '656', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('612', '657', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('613', '658', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('614', '659', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('615', '660', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('616', '661', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('617', '662', '230', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('618', '608', '216-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('619', '609', '216-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('620', '663', '231', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('621', '664', '232', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('622', '402', '132', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('623', '214', '48', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('624', '217', '51', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('625', '240', '58', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('626', '319', '86', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('627', '332', '95', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('628', '342', '99', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('629', '375', '116', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('630', '377', '118', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('631', '378', '118', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('632', '411', '137', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('633', '412', '137', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('634', '438', '148', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('635', '471', '167', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('636', '472', '167', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('637', '473', '167', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('638', '477', '171', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('639', '478', '171', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('640', '479', '171', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('641', '480', '171', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('642', '600', '213', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('643', '601', '213', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('644', '475', '169', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('645', '476', '170', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('646', '528', '188', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-13 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('647', '669', '234', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-12 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('648', '670', '234', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-12 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('649', '671', '234', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-12 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('650', '672', '234', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-12 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('651', '673', '234', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-12 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('652', '674', '234', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-12 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('653', '675', '234', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-12 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('654', '676', '234', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-12 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('655', '665', '233', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('656', '666', '233', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('657', '667', '233', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('658', '668', '233', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-11', '2', 'SI', '2024-05-11 00:00:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('659', '682', '237', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-13 21:06:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('660', '683', '237', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-13 21:06:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('661', '684', '237', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-13 21:06:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('662', '685', '237', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-13 21:06:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('663', '678', '236', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-13 21:16:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('664', '679', '236', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-13 21:16:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('665', '680', '236', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-13 21:16:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('666', '681', '236', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-12', '2', 'SI', '2024-05-13 21:16:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('667', '693', '240', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:28:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('668', '694', '240', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:28:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('669', '695', '240', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:28:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('670', '696', '240', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:28:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('671', '697', '240', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:28:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('672', '698', '240', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:28:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('673', '687', '239', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:31:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('674', '688', '239', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:31:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('675', '689', '239', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:31:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('676', '690', '239', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:31:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('677', '691', '239', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:31:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('678', '692', '239', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:31:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('679', '699', '241', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-13 23:37:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('680', '703', '245', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:04:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('681', '702', '244', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:06:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('682', '701', '243', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:06:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('683', '700', '242', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:07:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('684', '677', '235', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:13:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('685', '704', '246', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:22:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('686', '705', '246', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:22:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('687', '706', '246', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:22:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('688', '707', '247', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:31:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('689', '710', '249', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:35:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('690', '711', '249', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 00:35:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('691', '712', '250', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 14:50:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('692', '713', '250', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 14:50:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('693', '718', '253', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 17:40:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('694', '719', '253', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 17:40:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('695', '726', '256', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:06:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('696', '727', '256', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:06:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('697', '728', '256', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:06:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('698', '729', '256', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:06:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('699', '730', '256', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:06:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('700', '731', '257', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 18:10:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('701', '732', '257', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 18:10:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('702', '733', '257', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 18:10:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('703', '734', '257', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 18:10:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('704', '735', '257', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 18:10:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('705', '736', '257', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 18:10:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('706', '737', '257', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 18:10:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('707', '738', '258', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:38:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('708', '739', '258', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:38:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('709', '740', '258', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '1', 'SI', '2024-05-14 18:38:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('710', '741', '258', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:38:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('711', '742', '258', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:38:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('712', '743', '258', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-13', '2', 'SI', '2024-05-14 18:38:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('713', '474', '168', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 19:03:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('714', '686', '238', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 20:17:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('715', '746', '260', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 20:48:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('716', '747', '261', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 20:50:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('717', '748', '262', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 21:15:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('718', '749', '262', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 21:15:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('719', '750', '263', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 21:20:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('720', '751', '264', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 21:26:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('721', '752', '264', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 21:26:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('722', '753', '264', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 21:26:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('723', '487', '175', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:27:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('724', '526', '186', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:28:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('725', '586', '205', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:28:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('726', '588', '207', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:29:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('727', '597', '210', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:30:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('728', '598', '211', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:30:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('729', '599', '212', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:30:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('730', '607', '215', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:30:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('731', '610', '217', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 21:31:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('732', '716', '252', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 22:05:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('733', '717', '252', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 22:05:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('734', '723', '254-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 22:37:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('735', '724', '254-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 22:37:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('736', '755', '266', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 22:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('737', '756', '266', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 22:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('738', '757', '266', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 22:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('739', '758', '266', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 22:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('740', '759', '267', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 23:02:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('741', '760', '268', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 23:11:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('742', '761', '268', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 23:11:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('743', '762', '269', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 23:18:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('744', '763', '269', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '1', 'SI', '2024-05-14 23:18:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('745', '725', '255', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 23:22:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('746', '766', '271', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 23:34:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('747', '767', '272', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 23:36:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('748', '768', '273', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-14 23:40:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('749', '771', '276', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 16:28:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('750', '774', '279', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 16:57:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('751', '775', '279', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 16:57:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('752', '776', '280', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('753', '777', '280', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('754', '778', '280', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('755', '779', '280', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('756', '780', '280', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('757', '781', '281', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 18:08:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('758', '782', '281', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 18:08:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('759', '783', '282', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 18:09:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('760', '784', '282', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 18:09:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('761', '785', '282', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 18:09:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('762', '786', '282', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 18:09:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('763', '787', '282', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 18:09:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('764', '788', '282', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 18:09:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('765', '789', '282', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 18:09:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('766', '790', '282', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-15 18:09:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('767', '764', '270', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 18:14:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('768', '765', '270', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 18:14:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('769', '754', '265', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 19:36:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('770', '799', '288', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 20:08:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('771', '800', '288', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 20:08:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('772', '801', '288', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 20:08:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('773', '802', '288', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 20:08:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('774', '803', '288', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 20:08:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('775', '804', '288', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-14', '2', 'SI', '2024-05-15 20:08:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('776', '805', '289', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 20:19:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('777', '744', '259-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:04:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('778', '745', '259-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:04:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('779', '807', '291', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:06:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('780', '770', '275', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:32:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('781', '808', '292', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:40:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('782', '809', '292', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:40:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('783', '810', '292', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:40:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('784', '811', '292', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:40:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('785', '812', '292', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:40:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('786', '813', '292', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:40:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('787', '814', '292', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:40:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('788', '815', '292', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:40:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('789', '798', '287', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 22:42:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('790', '791', '283', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:07:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('791', '792', '283', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:07:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('792', '793', '283', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:07:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('793', '817', '294', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:12:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('794', '818', '294', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:12:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('795', '819', '294', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:12:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('796', '820', '295', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:26:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('797', '821', '296', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:31:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('798', '822', '297', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:35:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('799', '823', '297', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:35:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('800', '824', '297', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:35:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('801', '825', '297', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:35:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('802', '794', '284-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:39:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('803', '795', '284-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:39:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('804', '796', '285', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-15 23:54:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('805', '797', '286', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 00:14:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('806', '827', '299', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 00:16:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('807', '829', '301', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-16 15:58:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('808', '830', '302', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-16 16:06:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('809', '831', '302', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '2', 'SI', '2024-05-16 16:06:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('810', '832', '303', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-16 16:14:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('811', '833', '303', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-16 16:14:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('812', '841', '309', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:48:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('813', '842', '309', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:48:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('814', '843', '309', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:48:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('815', '844', '309', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:48:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('816', '845', '309', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:48:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('817', '846', '309', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:48:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('818', '847', '309', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:48:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('819', '848', '309', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:48:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('820', '828', '300', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 17:50:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('821', '851', '312', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 20:30:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('822', '852', '312', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 20:30:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('823', '853', '312', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 20:30:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('824', '854', '312', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 20:30:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('825', '855', '312', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 20:30:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('826', '816', '293', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 20:50:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('827', '857', '314', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 22:27:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('828', '835', '305', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 23:31:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('829', '836', '306-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 23:43:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('830', '837', '306-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 23:43:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('831', '838', '306-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 23:43:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('832', '858', '315', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 23:54:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('833', '859', '315', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 23:54:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('834', '860', '315', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 23:54:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('835', '861', '315', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 23:54:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('836', '862', '315', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 23:54:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('837', '863', '315', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-15', '1', 'SI', '2024-05-16 23:54:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('838', '839', '307', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 00:00:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('839', '865', '317', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 00:09:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('840', '866', '317', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 00:09:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('841', '840', '308', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '1', 'SI', '2024-05-16 00:20:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('842', '870', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('843', '871', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('844', '872', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('845', '873', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('846', '874', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('847', '875', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('848', '876', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('849', '877', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('850', '878', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('851', '879', '319', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 09:01:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('852', '881', '321', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 09:36:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('853', '773', '278', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 09:41:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('854', '886', '324', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 09:43:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('855', '806', '290', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 10:35:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('856', '889', '327', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 10:44:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('857', '890', '327', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 10:44:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('858', '891', '327', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 10:44:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('859', '892', '327', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 10:44:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('860', '893', '327', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 10:44:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('861', '894', '327', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 10:44:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('862', '864', '316', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 12:21:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('863', '908', '337', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-17 12:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('864', '909', '337', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-17 12:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('865', '910', '337', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-17 12:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('866', '911', '337', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-17 12:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('867', '912', '337', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-17 12:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('868', '913', '337', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-17 12:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('869', '914', '337', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-16', '2', 'SI', '2024-05-17 12:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('870', '917', '339', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 12:29:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('871', '918', '339', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 12:29:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('872', '927', '344-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 13:10:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('873', '928', '344-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 13:10:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('874', '929', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('875', '930', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('876', '931', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('877', '932', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('878', '933', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('879', '934', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('880', '935', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('881', '936', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('882', '937', '345', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 13:31:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('883', '938', '346', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 13:32:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('884', '939', '346', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 13:32:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('885', '940', '346', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 13:32:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('886', '941', '346', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 13:32:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('887', '942', '346', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 13:32:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('888', '943', '346', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 13:32:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('889', '945', '348', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 14:00:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('890', '946', '348', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 14:00:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('891', '826', '298', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 14:19:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('892', '884', '323-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 15:24:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('893', '885', '323-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 15:24:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('894', '880', '320', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 15:34:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('895', '948', '350', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 15:41:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('896', '949', '350', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 15:41:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('897', '882', '322-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 16:04:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('898', '883', '322-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 16:04:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('899', '952', '352', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 16:18:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('900', '867', '318-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 16:25:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('901', '868', '318-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 16:25:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('902', '869', '318-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 16:25:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('903', '953', '353', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:29:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('904', '954', '353', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:29:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('905', '955', '353', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:29:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('906', '956', '353', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:29:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('907', '957', '353', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:29:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('908', '958', '353', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:29:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('909', '959', '353', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:29:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('910', '960', '353', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:29:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('911', '903', '333', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 16:45:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('912', '906', '335', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:24:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('913', '904', '334-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:25:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('914', '905', '334-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:25:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('915', '901', '332-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:28:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('916', '902', '332-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:28:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('917', '907', '336', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:30:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('918', '922', '342-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:32:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('919', '923', '342-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:32:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('920', '961', '354', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:34:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('921', '919', '340', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:43:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('922', '924', '343-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:47:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('923', '925', '343-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:47:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('924', '926', '343-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 17:47:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('925', '964', '357', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 17:57:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('926', '965', '357', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 17:57:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('927', '966', '357', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 17:57:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('928', '967', '357', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 17:57:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('929', '968', '357', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 17:57:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('930', '969', '357', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 17:57:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('931', '915', '338-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '1', 'SI', '2024-05-17 18:01:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('932', '916', '338-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 18:01:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('933', '970', '358', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 18:12:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('934', '971', '358', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 18:12:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('935', '972', '359', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 18:16:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('936', '973', '359', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 18:16:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('937', '974', '359', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 18:16:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('938', '898', '329', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-17', '2', 'SI', '2024-05-17 18:19:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('939', '985', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('940', '986', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('941', '987', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('942', '988', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('943', '989', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('944', '990', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('945', '991', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('946', '992', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('947', '993', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('948', '994', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('949', '995', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('950', '996', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('951', '997', '365', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:01:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('952', '998', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('953', '999', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('954', '1000', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('955', '1001', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('956', '1002', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('957', '1003', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('958', '1004', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('959', '1005', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('960', '1006', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('961', '1007', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('962', '1008', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('963', '1009', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('964', '1010', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('965', '1011', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('966', '1012', '366', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:27:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('967', '1016', '368', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:34:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('968', '900', '331', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 08:50:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('969', '920', '341-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:51:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('970', '921', '341-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 08:51:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('971', '888', '326', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('972', '944', '347', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 09:35:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('973', '895', '328-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 09:35:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('974', '896', '328-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 09:35:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('975', '897', '328-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 09:35:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('976', '947', '349', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 10:06:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('977', '975', '360', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 10:10:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('978', '963', '356', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 10:12:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('979', '1024', '375', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 10:18:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('980', '1025', '375', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 10:18:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('981', '1022', '374', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 10:20:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('982', '1023', '374', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 10:20:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('983', '1030', '379', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 11:05:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('984', '1031', '379', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 11:05:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('985', '1043', '385', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 12:44:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('986', '899', '330', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 13:13:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('987', '1017', '369', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 13:37:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('988', '950', '351-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 13:40:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('989', '951', '351-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 13:40:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('990', '976', '361', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 14:51:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('991', '977', '361', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 14:51:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('992', '1048', '389', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:12:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('993', '1049', '389', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:12:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('994', '1050', '389', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:12:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('995', '1051', '389', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:12:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('996', '1052', '389', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:12:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('997', '1057', '391', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:38:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('998', '1058', '391', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:38:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('999', '1059', '391', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:38:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1000', '1060', '391', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:38:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1001', '1053', '390', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:42:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1002', '1054', '390', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:42:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1003', '1055', '390', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:42:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1004', '1056', '390', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 15:42:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1005', '1061', '392', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 15:59:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1006', '1062', '392', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 15:59:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1007', '1063', '393', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:00:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1008', '1064', '393', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:00:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1009', '1065', '394', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:12:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1010', '1066', '394', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:12:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1011', '1067', '394', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:12:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1012', '1068', '394', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:12:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1013', '1069', '394', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:12:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1014', '1070', '395', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:19:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1015', '1071', '395', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:19:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1016', '1021', '373', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:21:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1017', '1072', '396', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:22:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1018', '1073', '396', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:22:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1019', '1041', '383', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:26:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1020', '1020', '372', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:28:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1021', '1047', '388', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:30:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1022', '1019', '371', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:33:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1023', '1027', '377', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:35:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1024', '1074', '397', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:39:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1025', '1075', '397', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:39:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1026', '1076', '397', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:39:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1027', '1077', '397', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:39:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1028', '1026', '376', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-18 16:44:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1029', '1034', '381', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:57:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1030', '1042', '384', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 16:59:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1031', '1080', '400', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:12:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1032', '1081', '400', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:12:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1033', '1082', '400', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:12:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1034', '1083', '400', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:12:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1035', '1084', '400', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:12:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1036', '1085', '400', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:12:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1037', '1086', '401', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:26:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1038', '1087', '401', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:26:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1039', '1088', '401', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:26:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1040', '1089', '401', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:26:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1041', '1046', '387', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:33:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1042', '1044', '386-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:35:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1043', '1045', '386-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:35:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1044', '1090', '402', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:37:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1045', '1091', '402', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:37:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1046', '1092', '402', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:37:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1047', '1032', '380', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:46:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1048', '1033', '380', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:46:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1049', '1093', '403', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:51:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1050', '1094', '403', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:51:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1051', '1095', '403', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:51:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1052', '1096', '403', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:51:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1053', '1097', '404', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:56:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1054', '1098', '404', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:56:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1055', '1099', '404', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:56:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1056', '1100', '404', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:56:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1057', '1101', '404', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:56:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1058', '1102', '404', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 17:56:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1059', '1103', '405', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1060', '1104', '405', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1061', '1105', '405', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1062', '1106', '405', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1063', '1107', '405', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 18:00:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1064', '1108', '406', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-18 18:11:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1065', '1018', '370', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 08:27:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1066', '1013', '367-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 10:20:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1067', '1014', '367-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 10:20:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1068', '1015', '367-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 10:20:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1069', '1121', '416', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 11:46:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1070', '1122', '416', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 11:46:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1071', '1123', '416', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 11:46:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1072', '1124', '416', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 11:46:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1073', '1125', '416', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 11:46:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1074', '1126', '416', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 11:46:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1075', '1133', '420', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '1', 'SI', '2024-05-20 12:46:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1076', '1134', '420', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '1', 'SI', '2024-05-20 12:46:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1077', '1135', '420', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '1', 'SI', '2024-05-20 12:46:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1078', '1136', '420', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '1', 'SI', '2024-05-20 12:46:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1079', '1137', '420', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '1', 'SI', '2024-05-20 12:46:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1080', '1138', '420', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '1', 'SI', '2024-05-20 12:46:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1081', '1129', '419', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-20 12:48:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1082', '1130', '419', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-20 12:48:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1083', '1131', '419', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-20 12:48:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1084', '1132', '419', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '1', 'SI', '2024-05-20 12:48:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1085', '1147', '423', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:21:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1086', '1148', '423', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:21:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1087', '1149', '423', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:21:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1088', '1150', '423', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:21:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1089', '1143', '422', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:23:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1090', '1144', '422', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:23:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1091', '1145', '422', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:23:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1092', '1146', '422', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:23:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1093', '1139', '421', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1094', '1140', '421', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1095', '1141', '421', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1096', '1142', '421', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-19', '2', 'SI', '2024-05-20 15:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1097', '1078', '398', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 15:56:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1098', '962', '355', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 15:59:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1099', '1127', '417', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 16:29:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1100', '1158', '426', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-20 16:55:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1101', '1159', '426', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-20 16:55:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1102', '1160', '426', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-20 16:55:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1103', '1161', '426', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-20 16:55:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1104', '1162', '426', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-20 16:55:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1105', '1163', '426', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-18', '2', 'SI', '2024-05-20 16:55:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1106', '1152', '425', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 16:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1107', '1153', '425', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 16:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1108', '1154', '425', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 16:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1109', '1155', '425', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 16:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1110', '1156', '425', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 16:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1111', '1157', '425', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 16:58:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1112', '1164', '427', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:10:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1113', '1165', '427', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:10:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1114', '1166', '427', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:10:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1115', '1167', '427', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:10:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1116', '1168', '427', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '1', 'SI', '2024-05-20 17:10:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1117', '1110', '408', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:14:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1118', '1118', '413', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:26:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1119', '1171', '429', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:27:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1120', '1172', '430', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:28:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1121', '1173', '431', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:29:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1122', '1174', '432', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:30:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1123', '1175', '433', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:32:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1124', '1176', '433', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:32:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1125', '1177', '433', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:32:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1126', '1178', '433', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:32:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1127', '1179', '433', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:32:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1128', '1180', '434', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:33:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1129', '1181', '434', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:33:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1130', '1182', '434', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:33:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1131', '1184', '436', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:38:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1132', '1185', '437', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:40:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1133', '1128', '418', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:46:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1134', '1035', '382', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1135', '1036', '382', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1136', '1037', '382', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1137', '1038', '382', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1138', '1039', '382', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1139', '1040', '382', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1140', '980', '363', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1141', '981', '363', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1142', '982', '363', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1143', '983', '363', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1144', '978', '362', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1145', '979', '362', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:58:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1146', '462', '160', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 17:59:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1147', '1119', '414', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '2', 'SI', '2024-05-20 18:00:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1148', '1186', '438', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '1', 'SI', '2024-05-20 18:06:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1149', '1187', '438', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '1', 'SI', '2024-05-20 18:06:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1150', '1116', '412-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '1', 'SI', '2024-05-20 18:14:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1151', '1117', '412-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-20', '1', 'SI', '2024-05-20 18:14:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1152', '1189', '440', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 08:57:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1153', '1120', '415', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 11:47:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1154', '1197', '447', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:19:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1155', '1198', '447', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:19:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1156', '1199', '447', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:19:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1157', '1200', '447', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:19:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1158', '1201', '448', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:59:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1159', '1202', '448', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:59:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1160', '1203', '448', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:59:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1161', '1204', '448', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:59:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1162', '1205', '448', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:59:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1163', '1206', '448', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 12:59:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1164', '1151', '424', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 14:04:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1165', '1188', '439', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 14:35:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1166', '1208', '450', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 14:42:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1167', '1209', '450', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 14:42:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1168', '1210', '450', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 14:42:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1169', '1211', '450', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 14:42:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1170', '1245', '460', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 15:33:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1171', '1246', '460', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 15:33:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1172', '1247', '460', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 15:33:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1173', '1248', '460', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 15:33:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1174', '1249', '460', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 15:33:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1175', '1250', '460', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '2', 'SI', '2024-05-21 15:33:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1176', '1115', '411', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 16:05:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1177', '1251', '461', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 16:31:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1178', '1169', '428-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:05:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1179', '1170', '428-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:05:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1180', '1196', '446', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:47:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1181', '1194', '444', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:50:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1182', '1252', '462', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:58:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1183', '1253', '462', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:58:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1184', '1254', '462', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:58:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1185', '1255', '462', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:58:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1186', '1256', '462', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:58:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1187', '1257', '462', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:58:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1188', '1258', '462', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:58:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1189', '1195', '445', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 17:59:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1190', '1259', '463', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:00:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1191', '1260', '463', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:00:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1192', '1261', '464', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:04:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1193', '1190', '441-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:07:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1194', '1191', '441-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:07:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1195', '1262', '465', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:10:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1196', '1263', '465', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:10:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1197', '1264', '465', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:10:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1198', '1265', '466', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:12:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1199', '1244', '459', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-21', '1', 'SI', '2024-05-21 18:14:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1200', '1183', '435', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-22 08:37:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1201', '1277', '473', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 12:31:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1202', '1276', '472', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 12:33:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1203', '1280', '476', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 13:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1204', '1281', '476', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 13:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1205', '1282', '476', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 13:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1206', '1283', '476', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 13:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1207', '1284', '476', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 13:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1208', '1285', '476', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 13:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1209', '1286', '476', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 13:25:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1210', '1287', '477', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:29:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1211', '1288', '477', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:29:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1212', '1289', '477', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:29:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1213', '1290', '477', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:29:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1214', '1291', '477', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:29:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1215', '1292', '477', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:29:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1216', '1294', '479', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:51:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1217', '1295', '479', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:51:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1218', '1296', '479', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 14:51:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1219', '1207', '449', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 16:02:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1220', '1297', '480', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 16:11:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1221', '1274', '471-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 17:09:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1222', '1275', '471-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '1', 'SI', '2024-05-22 17:09:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1223', '1272', '469', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-22 17:30:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1224', '1299', '482', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-22 17:41:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1225', '1300', '482', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-22 17:41:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1226', '1301', '482', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-22 17:41:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1227', '1302', '482', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-22 17:41:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1228', '1303', '482', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-22 17:41:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1229', '1304', '483', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-22 17:49:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1230', '1279', '475', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 09:38:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1231', '1293', '478', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 10:48:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1232', '1336', '496', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:21:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1233', '1337', '496', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:21:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1234', '1338', '496', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:21:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1235', '1339', '496', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:21:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1236', '1332', '495', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:23:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1237', '1333', '495', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:23:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1238', '1334', '495', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:23:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1239', '1335', '495', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:23:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1240', '1328', '494', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:28:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1241', '1329', '494', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:28:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1242', '1330', '494', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:28:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1243', '1331', '494', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:28:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1244', '1278', '474', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:34:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1245', '1307', '485', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 15:41:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1246', '1340', '497', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-23 16:39:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1247', '1341', '497', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-23 16:39:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1248', '1342', '497', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-23 16:39:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1249', '1343', '497', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-23 16:39:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1250', '1344', '497', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-23 16:39:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1251', '1345', '497', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-22', '2', 'SI', '2024-05-23 16:39:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1252', '1346', '498', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 16:43:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1253', '1347', '498', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 16:43:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1254', '1348', '498', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 16:43:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1255', '1349', '498', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 16:43:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1256', '1350', '498', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 16:43:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1257', '1351', '498', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 16:43:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1258', '1352', '498', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 16:43:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1259', '1354', '500', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 16:59:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1260', '1353', '499', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:02:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1261', '1355', '501', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:12:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1262', '1356', '501', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:12:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1263', '1357', '501', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:12:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1264', '1358', '501', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:12:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1265', '1309', '487-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:15:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1266', '1310', '487-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:15:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1267', '1311', '487-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:15:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1268', '1312', '487-4', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:15:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1269', '1313', '488-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:19:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1270', '1314', '488-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:19:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1271', '1305', '484', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:25:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1272', '1306', '484', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:25:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1273', '1298', '481', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:35:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1274', '1359', '502', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:37:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1275', '1360', '502', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:37:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1276', '1361', '502', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:37:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1277', '1362', '502', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:37:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1278', '1364', '504', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:44:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1279', '1322', '492', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:48:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1280', '1323', '492', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:48:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1281', '1324', '492', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:48:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1282', '1325', '492', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:48:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1283', '1326', '492', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-23 17:48:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1284', '1327', '493', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:53:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1285', '1366', '506', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:58:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1286', '1367', '506', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:58:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1287', '1368', '506', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '2', 'SI', '2024-05-23 17:58:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1288', '1370', '508', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '2', 'SI', '2024-05-24 08:26:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1289', '1371', '508', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '2', 'SI', '2024-05-24 08:26:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1290', '1372', '509', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '2', 'SI', '2024-05-24 08:33:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1291', '1373', '509', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '2', 'SI', '2024-05-24 08:33:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1292', '1374', '509', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '2', 'SI', '2024-05-24 08:33:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1293', '1375', '510', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '2', 'SI', '2024-05-24 09:41:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1294', '1363', '503', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 11:29:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1295', '1378', '513', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 11:39:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1296', '1379', '513', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 11:39:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1297', '1320', '491', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:13:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1298', '1321', '491', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:13:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1299', '1381', '515', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:30:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1300', '1382', '515', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:30:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1301', '1383', '515', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:30:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1302', '1384', '515', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:30:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1303', '1385', '515', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:30:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1304', '1386', '515', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:30:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1305', '1387', '515', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:30:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1306', '1388', '516', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:34:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1307', '1389', '516', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:34:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1308', '1390', '516', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:34:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1309', '1391', '516', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 12:34:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1310', '1392', '517', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-24 13:45:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1311', '1393', '517', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-24 13:45:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1312', '1394', '517', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-24 13:45:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1313', '1395', '517', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-24 13:45:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1314', '1396', '517', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-24 13:45:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1315', '1397', '517', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-23', '1', 'SI', '2024-05-24 13:45:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1316', '1398', '518', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 13:49:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1317', '1399', '518', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 13:49:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1318', '1401', '520', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 14:31:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1319', '1406', '523', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 15:35:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1320', '1407', '523', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 15:35:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1321', '1408', '523', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 15:35:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1322', '1409', '523', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 15:35:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1323', '1410', '523', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 15:35:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1324', '1319', '490', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 15:38:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1325', '1411', '524', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 15:40:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1326', '1419', '530', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 17:08:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1327', '1423', '534', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 17:44:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1328', '1424', '534', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 17:44:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1329', '1425', '534', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 17:44:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1330', '1426', '534', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 17:44:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1331', '1427', '534', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 17:44:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1332', '1428', '534', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 17:44:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1333', '1432', '537', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 18:01:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1334', '1365', '505', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-24', '1', 'SI', '2024-05-24 19:02:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1335', '1404', '522', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:24:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1336', '1405', '522', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:24:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1337', '887', '325', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:28:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1338', '1113', '410', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:28:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1339', '1114', '410', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:28:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1340', '1440', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1341', '1441', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1342', '1442', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1343', '1443', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1344', '1444', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1345', '1445', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1346', '1446', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1347', '1447', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1348', '1448', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1349', '1449', '542', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:34:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1350', '1450', '543', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:44:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1351', '1451', '544', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:48:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1352', '1452', '544', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:48:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1353', '1308', '486', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 08:54:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1354', '1421', '532', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 09:07:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1355', '850', '311', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 09:32:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1356', '1400', '519', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 09:34:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1357', '1420', '531', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 09:40:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1358', '1369', '507', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 09:48:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1359', '1422', '533', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 09:56:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1360', '1376', '511', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 09:57:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1361', '1434', '539-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 10:01:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1362', '1435', '539-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 10:01:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1363', '1436', '539-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 10:01:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1364', '1416', '527', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 10:12:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1365', '1380', '514', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 10:43:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1366', '1402', '521-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 10:56:51');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1367', '1403', '521-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 10:56:51');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1368', '1377', '512', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 13:32:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1369', '1430', '536-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 13:46:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1370', '1431', '536-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 13:46:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1371', '1480', '561', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 14:04:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1372', '1481', '561', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 14:04:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1373', '1482', '561', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 14:04:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1374', '1483', '561', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 14:04:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1375', '1484', '561', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 14:04:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1376', '1485', '561', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 14:04:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1377', '1453', '545', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 14:07:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1378', '1429', '535', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 15:23:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1379', '1454', '546', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 15:24:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1380', '1500', '572', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 15:42:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1381', '1501', '572', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 15:42:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1382', '1502', '572', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 15:42:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1383', '1461', '551', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 15:49:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1384', '1462', '551', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 15:49:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1385', '1459', '549', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 16:21:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1386', '1463', '552', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 16:51:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1387', '1464', '552', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 16:51:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1388', '1465', '552', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 16:51:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1389', '1504', '574', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:07:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1390', '1505', '574', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:07:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1391', '1506', '574', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:07:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1392', '1507', '574', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:07:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1393', '1438', '541-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:15:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1394', '1439', '541-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:15:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1395', '1437', '540', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:18:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1396', '1468', '554', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:23:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1397', '1508', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1398', '1509', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1399', '1510', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1400', '1511', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1401', '1512', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1402', '1513', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1403', '1514', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1404', '1515', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1405', '1516', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1406', '1517', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1407', '1518', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1408', '1519', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1409', '1520', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1410', '1521', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1411', '1522', '575', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:23:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1412', '1478', '559', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:33:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1413', '1466', '553-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:47:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1414', '1467', '553-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:47:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1415', '1477', '558', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:52:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1416', '1455', '547', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 17:53:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1417', '1476', '557', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 17:58:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1418', '1433', '538', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 18:00:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1419', '1524', '577', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 18:11:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1420', '1525', '578', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 18:30:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1421', '1526', '578', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 18:30:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1422', '1527', '578', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 18:30:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1423', '1528', '578', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 18:30:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1424', '1497', '571', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:10:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1425', '1498', '571', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:10:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1426', '1499', '571', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:10:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1427', '1529', '579', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:12:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1428', '1530', '579', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:12:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1429', '1531', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1430', '1532', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1431', '1533', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1432', '1534', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1433', '1535', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1434', '1536', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1435', '1537', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1436', '1538', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1437', '1539', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1438', '1540', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1439', '1541', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1440', '1542', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1441', '1543', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1442', '1544', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1443', '1545', '580', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '2', 'SI', '2024-05-25 19:30:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1444', '1546', '581', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 19:37:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1445', '1547', '581', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 19:37:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1446', '1548', '581', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 19:37:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1447', '1549', '581', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-25 19:37:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1448', '1552', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1449', '1553', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1450', '1554', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1451', '1555', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1452', '1556', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1453', '1557', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1454', '1558', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1455', '1559', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1456', '1560', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1457', '1561', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1458', '1562', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1459', '1563', '583', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-27 09:28:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1460', '1469', '555-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 09:39:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1461', '1470', '555-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 09:39:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1462', '1568', '586', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 09:59:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1463', '1582', '593', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-27 14:45:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1464', '1583', '593', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-27 14:45:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1465', '1584', '593', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-27 14:45:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1466', '1585', '593', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-27 14:45:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1467', '1586', '593', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-27 14:45:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1468', '1587', '593', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-25', '1', 'SI', '2024-05-27 14:45:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1469', '1576', '592', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '1', 'SI', '2024-05-27 14:48:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1470', '1577', '592', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '1', 'SI', '2024-05-27 14:48:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1471', '1578', '592', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '1', 'SI', '2024-05-27 14:48:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1472', '1579', '592', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '1', 'SI', '2024-05-27 14:48:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1473', '1580', '592', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '1', 'SI', '2024-05-27 14:48:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1474', '1581', '592', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '1', 'SI', '2024-05-27 14:48:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1475', '1588', '594', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 14:59:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1476', '1589', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1477', '1590', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1478', '1591', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1479', '1592', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1480', '1593', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1481', '1594', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1482', '1595', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1483', '1596', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1484', '1597', '595', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 15:39:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1485', '1564', '584', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 16:28:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1486', '1598', '596', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 16:30:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1487', '1569', '587', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 17:49:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1488', '1599', '597', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 18:24:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1489', '1600', '597', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 18:24:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1490', '1601', '597', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 18:24:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1491', '1602', '597', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '1', 'SI', '2024-05-27 18:24:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1492', '1413', '526', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 09:00:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1493', '1414', '526', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 09:00:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1494', '1415', '526', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 09:00:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1495', '1565', '585', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 09:30:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1496', '1566', '585', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 09:30:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1497', '1567', '585', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 09:30:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1498', '1605', '600', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 11:55:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1499', '1606', '601', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:00:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1500', '1607', '601', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:00:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1501', '1608', '601', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:00:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1502', '1610', '603', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:10:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1503', '1611', '604', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:23:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1504', '1612', '604', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:23:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1505', '1613', '604', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:23:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1506', '1614', '604', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:23:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1507', '1615', '604', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:23:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1508', '1616', '605', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:25:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1509', '1617', '606', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:27:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1510', '1618', '606', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:27:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1511', '1619', '606', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:27:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1512', '1620', '606', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 12:27:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1513', '1624', '609', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-28 12:57:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1514', '1625', '609', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-28 12:57:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1515', '1626', '609', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-28 12:57:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1516', '1627', '609', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-28 12:57:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1517', '1628', '609', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-28 12:57:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1518', '1629', '609', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-27', '2', 'SI', '2024-05-28 12:57:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1519', '1642', '614', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:38:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1520', '1643', '614', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:38:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1521', '1644', '614', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:38:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1522', '1645', '614', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:38:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1523', '1638', '613', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:41:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1524', '1639', '613', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:41:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1525', '1640', '613', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:41:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1526', '1641', '613', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:41:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1527', '1634', '612', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:43:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1528', '1635', '612', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:43:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1529', '1636', '612', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:43:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1530', '1637', '612', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-26', '2', 'SI', '2024-05-28 14:43:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1531', '1648', '616', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 14:44:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1532', '1269', '468', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 15:11:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1533', '1270', '468', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 15:11:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1534', '1271', '468', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 15:11:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1535', '1621', '607-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:04:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1536', '1622', '607-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:04:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1537', '1623', '608', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:08:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1538', '1604', '599', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:16:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1539', '1660', '624', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:29:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1540', '1661', '624', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:29:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1541', '1662', '624', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:29:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1542', '1663', '625', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:30:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1543', '1609', '602', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:33:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1544', '1646', '615-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:43:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1545', '1647', '615-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:43:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1546', '1632', '611', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '1', 'SI', '2024-05-28 17:51:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1547', '1633', '611', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '1', 'SI', '2024-05-28 17:51:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1548', '1664', '626', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '2', 'SI', '2024-05-28 17:59:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1549', '1650', '618-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 08:41:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1550', '1651', '618-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 08:41:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1551', '1523', '576', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 08:44:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1552', '1266', '467', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:45:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1553', '1267', '467', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:45:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1554', '1268', '467', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:45:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1555', '1273', '470', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:45:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1556', '1192', '442', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:45:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1557', '1315', '489', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:47:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1558', '1316', '489', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:47:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1559', '1317', '489', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:47:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1560', '1318', '489', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:47:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1561', '1079', '399', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:47:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1562', '1028', '378', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:47:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1563', '1029', '378', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:47:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1564', '849', '310', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:48:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1565', '834', '304', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:48:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1566', '769', '274', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:48:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1567', '856', '313', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:49:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1568', '984', '364', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:49:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1569', '1418', '529', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:50:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1570', '1456', '548', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:50:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1571', '1457', '548', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:50:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1572', '1458', '548', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:50:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1573', '1471', '556', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:51:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1574', '1472', '556', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:51:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1575', '1473', '556', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:51:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1576', '1474', '556', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:51:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1577', '1475', '556', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:51:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1578', '1417', '528', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:51:51');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1579', '1412', '525', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:52:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1580', '1111', '409', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:52:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1581', '1112', '409', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:52:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1582', '1460', '550', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 08:53:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1583', '1550', '582-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 08:58:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1584', '1551', '582-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 08:58:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1585', '1649', '617', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 09:44:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1586', '1652', '619', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 10:22:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1587', '1653', '619', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 10:22:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1588', '1654', '620', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '2', 'SI', '2024-05-29 11:48:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1589', '1656', '622-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 12:41:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1590', '1657', '622-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 12:41:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1591', '1658', '622-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 12:41:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1592', '1669', '630', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 15:16:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1593', '1671', '632', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 16:03:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1594', '1683', '641', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 16:25:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1595', '1684', '642', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 16:28:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1596', '1685', '642', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 16:28:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1597', '1686', '642', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 16:28:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1598', '1687', '643', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:28:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1599', '1688', '643', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:28:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1600', '1689', '643', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:28:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1601', '1690', '643', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:28:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1602', '1691', '643', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:28:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1603', '1665', '627', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:32:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1604', '1692', '644', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '1', 'SI', '2024-05-29 17:33:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1605', '1693', '644', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '1', 'SI', '2024-05-29 17:33:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1606', '1694', '644', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '1', 'SI', '2024-05-29 17:33:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1607', '1695', '644', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '1', 'SI', '2024-05-29 17:33:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1608', '1696', '644', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '1', 'SI', '2024-05-29 17:33:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1609', '1697', '644', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-28', '1', 'SI', '2024-05-29 17:33:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1610', '1670', '631', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:39:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1611', '1700', '646', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:46:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1612', '1701', '646', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:46:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1613', '1702', '646', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:46:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1614', '1678', '638', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:54:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1615', '1703', '647', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 17:55:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1616', '1704', '648', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 18:02:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1617', '1705', '648', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 18:02:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1618', '1706', '648', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 18:02:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1619', '1707', '649', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 18:10:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1620', '1708', '649', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 18:10:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1621', '1709', '649', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 18:10:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1622', '1710', '649', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 18:10:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1623', '1711', '649', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-29 18:10:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1624', '1721', '655', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 09:19:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1625', '1722', '655', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 09:19:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1626', '1723', '655', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 09:19:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1627', '1666', '628', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 09:45:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1628', '1490', '565-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 09:52:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1629', '1491', '565-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 09:52:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1630', '1673', '634-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 10:06:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1631', '1674', '634-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 10:06:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1632', '1741', '663', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 11:07:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1633', '1740', '662', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 11:08:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1634', '1739', '661', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 11:08:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1635', '1738', '660', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 11:09:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1636', '1745', '667', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 12:38:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1637', '1747', '669-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 12:46:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1638', '1748', '669-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 12:46:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1639', '1698', '645', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 13:19:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1640', '1699', '645', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 13:19:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1641', '1655', '621', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 14:09:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1642', '1767', '675', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 14:31:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1643', '1768', '675', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 14:31:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1644', '1753', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1645', '1754', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1646', '1755', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1647', '1756', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1648', '1757', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1649', '1758', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1650', '1759', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1651', '1760', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1652', '1761', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1653', '1762', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1654', '1763', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1655', '1764', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1656', '1765', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1657', '1766', '674', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:32:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1658', '1777', '678', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:41:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1659', '1778', '678', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:41:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1660', '1779', '678', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:41:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1661', '1780', '678', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:41:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1662', '1773', '677', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:42:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1663', '1774', '677', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:42:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1664', '1775', '677', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:42:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1665', '1776', '677', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:42:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1666', '1769', '676', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:43:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1667', '1770', '676', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:43:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1668', '1771', '676', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:43:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1669', '1772', '676', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 14:43:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1670', '1682', '640', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 14:48:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1671', '1725', '657-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 15:08:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1672', '1726', '657-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 15:08:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1673', '1713', '651', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 15:32:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1674', '1712', '650', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 16:00:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1675', '1714', '652', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:17:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1676', '1676', '636', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:26:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1677', '1727', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1678', '1728', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1679', '1729', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1680', '1730', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1681', '1731', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1682', '1732', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1683', '1733', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1684', '1734', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1685', '1735', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1686', '1736', '658', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:30:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1687', '1715', '653', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:35:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1688', '1716', '653', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:35:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1689', '1717', '653', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:35:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1690', '1718', '653', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 16:35:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1691', '1795', '689', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 17:09:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1692', '1724', '656', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 17:14:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1693', '1802', '695', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 17:20:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1694', '1719', '654-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 17:37:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1695', '1720', '654-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 17:37:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1696', '1781', '679', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 17:41:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1697', '1749', '670', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 17:58:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1698', '1750', '671', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 18:22:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1699', '1752', '673', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-05-31 18:43:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1700', '1751', '672', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 18:47:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1701', '1743', '665', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 18:53:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1702', '1818', '701', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-31 23:55:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1703', '1819', '701', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-31 23:55:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1704', '1820', '701', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-31 23:55:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1705', '1821', '701', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-31 23:55:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1706', '1822', '701', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-31 23:55:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1707', '1823', '701', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-29', '1', 'SI', '2024-05-31 23:55:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1708', '1812', '700', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 23:56:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1709', '1813', '700', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 23:56:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1710', '1814', '700', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 23:56:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1711', '1815', '700', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 23:56:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1712', '1816', '700', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 23:56:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1713', '1817', '700', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '1', 'SI', '2024-05-31 23:56:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1714', '1793', '687', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:17:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1715', '1824', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1716', '1825', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1717', '1826', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1718', '1827', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1719', '1828', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1720', '1829', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1721', '1830', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1722', '1831', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1723', '1832', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1724', '1833', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1725', '1834', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1726', '1835', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1727', '1836', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1728', '1837', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1729', '1838', '702', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:23:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1730', '1839', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1731', '1840', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1732', '1841', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1733', '1842', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1734', '1843', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1735', '1844', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1736', '1845', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1737', '1846', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1738', '1847', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1739', '1848', '703', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 08:36:32');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1740', '1737', '659', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 08:56:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1741', '1783', '681-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:04:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1742', '1784', '681-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:04:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1743', '1785', '681-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:04:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1744', '1786', '681-4', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:04:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1745', '1787', '681-5', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:04:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1746', '1792', '686', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 09:19:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1747', '1850', '705', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:20:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1748', '1851', '705', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:20:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1749', '1746', '668', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:23:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1750', '1801', '694', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:32:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1751', '1853', '707', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 09:36:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1752', '1854', '708', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:36:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1753', '1855', '708', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 09:36:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1754', '1859', '711', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 09:59:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1755', '1744', '666', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 10:04:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1756', '1806', '699-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 10:17:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1757', '1807', '699-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 10:17:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1758', '1808', '699-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 10:17:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1759', '1809', '699-4', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 10:17:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1760', '1810', '699-5', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 10:17:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1761', '1811', '699-6', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 10:17:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1762', '1794', '688', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 10:18:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1763', '1804', '697', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 10:21:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1764', '1800', '693', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 10:32:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1765', '1797', '691', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 10:45:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1766', '1796', '690', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 10:47:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1767', '1791', '685', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 11:51:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1768', '1874', '724', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 13:19:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1769', '1875', '725', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 13:52:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1770', '1803', '696', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 14:49:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1771', '1860', '712', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:02:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1772', '1805', '698', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:14:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1773', '1863', '715', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:31:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1774', '1798', '692', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:35:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1775', '1799', '692', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:35:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1776', '1890', '729', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-06-01 15:50:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1777', '1891', '729', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-06-01 15:50:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1778', '1892', '729', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-06-01 15:50:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1779', '1893', '729', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-06-01 15:50:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1780', '1894', '729', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-06-01 15:50:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1781', '1895', '729', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-05-31', '2', 'SI', '2024-06-01 15:50:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1782', '1896', '730', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:58:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1783', '1897', '730', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:58:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1784', '1898', '730', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:58:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1785', '1899', '730', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:58:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1786', '1900', '730', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:58:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1787', '1901', '730', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 15:58:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1788', '1876', '726', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 16:13:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1789', '1873', '723', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 16:16:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1790', '1902', '731', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 16:19:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1791', '1866', '718-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 16:29:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1792', '1867', '718-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 16:29:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1793', '1862', '714', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 16:31:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1794', '1865', '717', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 17:06:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1795', '1864', '716', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '2', 'SI', '2024-06-01 17:58:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1796', '1903', '732', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-01 17:59:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1797', '1904', '733', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:11:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1798', '1905', '733', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:11:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1799', '1872', '722', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:27:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1800', '1871', '721', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:30:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1801', '1908', '736', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:32:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1802', '1909', '736', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:32:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1803', '1857', '710-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:44:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1804', '1858', '710-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:44:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1805', '1888', '728-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:46:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1806', '1889', '728-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 09:46:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1807', '1868', '719-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 10:09:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1808', '1869', '719-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 10:09:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1809', '1849', '704', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 11:05:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1810', '1925', '745', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-02', '1', 'SI', '2024-06-03 12:38:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1811', '1926', '745', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-02', '1', 'SI', '2024-06-03 12:38:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1812', '1927', '745', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-02', '1', 'SI', '2024-06-03 12:38:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1813', '1928', '745', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-02', '1', 'SI', '2024-06-03 12:38:34');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1814', '1921', '744', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 12:39:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1815', '1922', '744', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 12:39:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1816', '1923', '744', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 12:39:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1817', '1924', '744', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 12:39:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1818', '1935', '750', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:13:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1819', '1936', '750', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:13:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1820', '1937', '750', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:13:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1821', '1907', '735', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:15:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1822', '1912', '739', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:17:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1823', '1948', '754', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-03 14:32:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1824', '1949', '754', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-03 14:32:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1825', '1950', '754', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-03 14:32:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1826', '1951', '754', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-03 14:32:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1827', '1952', '754', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-03 14:32:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1828', '1953', '754', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-01', '1', 'SI', '2024-06-03 14:32:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1829', '1938', '751', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:34:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1830', '1939', '751', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:34:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1831', '1940', '751', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:34:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1832', '1941', '751', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:34:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1833', '1942', '751', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:34:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1834', '1943', '751', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:34:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1835', '1954', '755', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:41:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1836', '1955', '755', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:41:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1837', '1956', '755', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:41:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1838', '1957', '755', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:41:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1839', '1958', '755', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:41:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1840', '1959', '755', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:41:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1841', '1960', '755', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 14:41:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1842', '1962', '757', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:16:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1843', '1963', '757', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:16:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1844', '1964', '757', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:16:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1845', '1966', '759', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:25:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1846', '1965', '758', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:26:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1847', '1911', '738', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:46:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1848', '1967', '760', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:57:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1849', '1968', '761', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:58:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1850', '1969', '762', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 15:59:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1851', '1970', '763', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 16:00:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1852', '1971', '764', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 16:01:15');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1853', '1972', '765', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 16:02:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1854', '1913', '740', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 16:19:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1855', '1931', '747', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '2', 'SI', '2024-06-03 16:57:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1856', '1906', '734', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '2', 'SI', '2024-06-03 17:29:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1857', '1929', '746', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '2', 'SI', '2024-06-03 17:36:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1858', '1930', '746', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '2', 'SI', '2024-06-03 17:36:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1859', '1961', '756', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '2', 'SI', '2024-06-03 17:59:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1860', '1976', '768', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 19:45:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1861', '1977', '768', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-03 19:45:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1862', '1910', '737', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 08:50:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1863', '1946', '753', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 09:35:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1864', '1947', '753', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 09:35:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1865', '1918', '743', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 09:38:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1866', '1919', '743', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 09:38:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1867', '1920', '743', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 09:38:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1868', '1861', '713', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 10:02:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1869', '1932', '748', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 10:58:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1870', '1983', '772', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 11:56:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1871', '1984', '772', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 11:56:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1872', '1985', '772', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 11:56:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1873', '1986', '772', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 11:56:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1874', '1987', '772', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 11:56:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1875', '1988', '772', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 11:56:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1876', '1989', '773', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 12:07:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1877', '1992', '776', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-04 13:24:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1878', '1993', '776', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-04 13:24:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1879', '1994', '776', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-04 13:24:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1880', '1995', '776', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-04 13:24:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1881', '1996', '776', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-04 13:24:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1882', '1997', '777', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-04 14:04:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1883', '1998', '777', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-04 14:04:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1884', '1999', '777', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-03', '1', 'SI', '2024-06-04 14:04:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1885', '2000', '778', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 14:10:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1886', '2001', '778', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 14:10:09');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1887', '2002', '778', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 14:10:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1888', '2003', '778', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 14:10:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1889', '2006', '780', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 14:46:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1890', '2007', '780', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 14:46:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1891', '2008', '780', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 14:46:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1892', '2009', '780', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '1', 'SI', '2024-06-04 14:46:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1893', '1979', '770-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 16:35:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1894', '1980', '770-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 16:35:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1895', '1981', '770-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 16:35:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1896', '1975', '767', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:11:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1897', '1990', '774', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:14:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1898', '1978', '769', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:17:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1899', '2010', '781', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:22:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1900', '2011', '781', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:22:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1901', '2012', '781', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:22:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1902', '2013', '781', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:22:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1903', '2014', '782', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:27:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1904', '2015', '782', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:27:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1905', '2016', '782', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:27:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1906', '1991', '775', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 17:48:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1907', '1982', '771', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-04', '2', 'SI', '2024-06-04 18:33:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1908', '2021', '786', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 10:58:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1909', '2022', '786', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 10:58:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1910', '2023', '787', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 11:00:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1911', '2024', '788', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 12:02:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1912', '2019', '785', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 12:47:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1913', '2020', '785', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 12:47:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1914', '2025', '789', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 12:54:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1915', '2026', '789', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 12:54:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1916', '2027', '789', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 12:54:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1917', '2028', '790', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 13:42:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1918', '2029', '791', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 13:55:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1919', '2030', '791', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 13:55:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1920', '2031', '791', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 13:55:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1921', '2032', '791', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 13:55:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1922', '2033', '791', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 13:55:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1923', '2034', '791', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 13:55:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1924', '2035', '791', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 13:55:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1925', '2036', '792', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 14:14:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1926', '2042', '796', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 15:45:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1927', '2018', '784', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 16:06:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1928', '2043', '797', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 16:09:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1929', '2004', '779', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 16:19:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1930', '2005', '779', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 16:19:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1931', '2044', '798', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 16:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1932', '1973', '766-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 17:08:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1933', '1974', '766-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 17:08:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1934', '2045', '799', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 17:16:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1935', '2046', '799', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 17:16:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1936', '2047', '799', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 17:16:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1937', '2049', '801', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 17:43:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1938', '2050', '801', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 17:43:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1939', '2051', '801', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 17:43:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1940', '2052', '801', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 17:43:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1941', '2053', '801', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 17:43:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1942', '1496', '570', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:08:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1943', '1495', '569', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:08:25');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1944', '1503', '573', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:08:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1945', '1573', '590', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:09:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1946', '1574', '590', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:09:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1947', '1489', '564', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:09:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1948', '1486', '562', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:10:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1949', '1487', '563', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:10:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1950', '1488', '563', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:10:57');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1951', '1479', '560', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:14:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1952', '1492', '566', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:15:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1953', '1493', '567', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:18:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1954', '1494', '568', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:19:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1955', '1877', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1956', '1878', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1957', '1879', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1958', '1880', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1959', '1881', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1960', '1882', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1961', '1883', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1962', '1884', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1963', '1885', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1964', '1886', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1965', '1887', '727', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:21:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1966', '2017', '783', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:26:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1967', '1575', '591', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:27:11');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1968', '1915', '742', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:28:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1969', '1916', '742', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:28:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1970', '1917', '742', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:28:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1971', '1856', '709', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 18:35:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1972', '1870', '720', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 18:35:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1973', '1914', '741', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 18:35:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1974', '1933', '749', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 18:36:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1975', '1934', '749', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '1', 'SI', '2024-06-05 18:36:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1976', '1570', '588', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:37:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1977', '1571', '589', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:38:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1978', '1572', '589', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:38:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1979', '1667', '629', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:39:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1980', '1668', '629', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:39:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1981', '1672', '633', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:39:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1982', '1603', '598', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:39:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1983', '1677', '637', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:40:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1984', '1659', '623', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:40:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1985', '1675', '635', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:40:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1986', '1788', '682', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:41:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1987', '1742', '664', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:43:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1988', '1782', '680', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-05', '2', 'SI', '2024-06-05 18:44:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1989', '2037', '793', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 09:36:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1990', '2038', '793', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 09:36:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1991', '2039', '794', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 09:37:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1992', '2040', '794', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 09:37:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1993', '2054', '802', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 09:57:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1994', '2061', '805', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 12:11:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1995', '2064', '807', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 12:45:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1996', '2065', '807', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 12:45:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1997', '2066', '808', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:48:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1998', '2067', '808', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:48:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('1999', '2068', '808', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:48:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2000', '2069', '808', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:48:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2001', '2070', '808', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:48:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2002', '2071', '808', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:48:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2003', '2072', '808', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:48:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2004', '2073', '808', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:48:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2005', '2074', '809', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:52:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2006', '2075', '809', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:52:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2007', '2076', '809', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:52:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2008', '2077', '809', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 13:52:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2009', '2078', '810', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-06 13:55:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2010', '2079', '810', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-06 13:55:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2011', '2080', '810', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-06 13:55:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2012', '2081', '810', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-06 13:55:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2013', '2082', '810', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-06 13:55:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2014', '2083', '810', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-06 13:55:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2015', '2084', '810', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-06 13:55:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2016', '2085', '811', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 14:24:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2017', '2086', '811', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 14:24:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2018', '2041', '795', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 14:27:49');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2019', '2055', '803', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 16:59:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2020', '2056', '803', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 16:59:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2021', '2094', '817', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:04:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2022', '2095', '817', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:04:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2023', '2057', '804', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:10:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2024', '2058', '804', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:10:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2025', '2059', '804', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:10:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2026', '2060', '804', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:10:17');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2027', '2062', '806', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:10:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2028', '2063', '806', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:10:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2029', '2048', '800', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-06 17:43:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2030', '2087', '812', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 09:58:02');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2031', '2102', '819', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:05:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2032', '2113', '827', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:15:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2033', '2114', '827', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:15:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2034', '2115', '827', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:15:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2035', '2116', '827', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:15:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2036', '2117', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2037', '2118', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2038', '2119', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2039', '2120', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2040', '2121', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2041', '2122', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2042', '2123', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2043', '2124', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2044', '2125', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2045', '2126', '828', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 12:26:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2046', '2129', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2047', '2130', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2048', '2131', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2049', '2132', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2050', '2133', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2051', '2134', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2052', '2135', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2053', '2136', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2054', '2137', '831', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 12:41:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2055', '2088', '813', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 14:25:38');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2056', '2104', '821', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 14:55:30');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2057', '2149', '838', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 15:45:29');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2058', '2141', '833', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 16:45:28');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2059', '2110', '824', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 16:51:47');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2060', '2111', '825', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 16:54:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2061', '2103', '820', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-07 16:59:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2062', '2106', '823-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 16:59:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2063', '2107', '823-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 16:59:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2064', '2108', '823-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 16:59:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2065', '2109', '823-4', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 16:59:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2066', '2105', '822', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:11:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2067', '2090', '815', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:35:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2068', '2142', '834', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:42:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2069', '2143', '834', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:42:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2070', '2144', '834', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:42:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2071', '2145', '834', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:42:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2072', '2146', '835', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:45:41');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2073', '2128', '830', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:49:24');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2074', '2147', '836', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 17:55:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2075', '2150', '839', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 20:08:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2076', '2157', '843', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-07 21:14:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2077', '2158', '843', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-07 21:14:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2078', '2159', '843', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-07 21:14:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2079', '2160', '843', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-07 21:14:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2080', '2161', '843', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-07 21:14:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2081', '2162', '843', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-07 21:14:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2082', '2163', '843', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '1', 'SI', '2024-06-07 21:14:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2083', '2164', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2084', '2165', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2085', '2166', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2086', '2167', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2087', '2168', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2088', '2169', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2089', '2170', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2090', '2171', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2091', '2172', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2092', '2173', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2093', '2174', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2094', '2175', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2095', '2176', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2096', '2177', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2097', '2178', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2098', '2179', '844', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 21:57:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2099', '2181', '846', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 22:02:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2100', '2180', '845', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-07 22:02:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2101', '2148', '837', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 08:47:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2102', '2112', '826', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 08:51:06');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2103', '2127', '829', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 09:54:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2104', '2091', '816-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 09:59:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2105', '2092', '816-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 09:59:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2106', '2093', '816-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 09:59:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2107', '2151', '840-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:06:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2108', '2152', '840-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:06:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2109', '2155', '842-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:12:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2110', '2156', '842-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:12:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2111', '2153', '841', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:15:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2112', '2154', '841', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:15:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2113', '2096', '818-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:24:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2114', '2097', '818-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:24:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2115', '2098', '818-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:24:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2116', '2099', '818-4', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:24:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2117', '2100', '818-5', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:24:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2118', '2101', '818-6', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:24:56');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2119', '2182', '847', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:42:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2120', '2183', '847', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:42:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2121', '2184', '847', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:42:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2122', '2185', '847', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 10:42:22');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2123', '2089', '814', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 11:28:53');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2124', '2196', '857', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 11:34:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2125', '2197', '857', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 11:34:50');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2126', '2138', '832-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 12:44:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2127', '2139', '832-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 12:44:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2128', '2140', '832-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 12:44:40');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2129', '2216', '871', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-08 14:29:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2130', '2217', '871', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-08 14:29:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2131', '2218', '871', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-08 14:29:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2132', '2219', '871', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-08 14:29:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2133', '2220', '871', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '1', 'SI', '2024-06-08 14:29:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2134', '2221', '871', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-07', '2', 'SI', '2024-06-08 14:29:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2135', '2187', '849', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 14:37:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2136', '2223', '873', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 14:39:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2137', '2192', '853', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 15:13:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2138', '2213', '868', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 15:42:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2139', '2225', '875-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 15:56:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2140', '2226', '875-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 15:56:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2141', '2186', '848', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 16:11:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2142', '2193', '854', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 16:28:01');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2143', '2212', '867', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 16:30:00');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2144', '2190', '851', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 16:36:18');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2145', '2227', '876', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 16:44:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2146', '2228', '877', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 16:51:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2147', '2194', '855', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 16:52:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2148', '2207', '863', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 16:59:16');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2149', '2229', '878', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 17:04:14');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2150', '2191', '852', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:07:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2151', '2215', '870', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:11:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2152', '2222', '872', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:14:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2153', '2236', '881', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 17:24:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2154', '2231', '880', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:24:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2155', '2232', '880', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:24:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2156', '2233', '880', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:24:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2157', '2234', '880', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:24:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2158', '2235', '880', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:24:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2159', '2195', '856', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 17:28:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2160', '2239', '883', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:30:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2161', '2240', '883', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 17:30:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2162', '2206', '862', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '1', 'SI', '2024-06-08 17:45:58');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2163', '2208', '864', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 18:03:36');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2164', '2209', '865', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 18:04:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2165', '2210', '866', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 18:10:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2166', '2211', '866', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-08 18:10:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2167', '2204', '861-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 09:30:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2168', '2205', '861-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 09:30:52');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2169', '2230', '879', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 12:04:07');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2170', '2248', '888', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 14:44:35');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2171', '2246', '887-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 14:46:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2172', '2247', '887-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 14:46:27');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2173', '2198', '858', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 14:47:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2174', '2257', '891', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 14:51:43');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2175', '2267', '899', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 14:56:33');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2176', '2268', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2177', '2269', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2178', '2270', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2179', '2271', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2180', '2272', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2181', '2273', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2182', '2274', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2183', '2275', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2184', '2276', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2185', '2277', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2186', '2278', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2187', '2279', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2188', '2280', '900', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 15:14:19');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2189', '2287', '902', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 15:22:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2190', '2288', '902', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 15:22:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2191', '2289', '902', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 15:22:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2192', '2290', '902', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 15:22:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2193', '2291', '902', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 15:22:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2194', '2292', '902', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 15:22:12');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2195', '2281', '901', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 15:24:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2196', '2282', '901', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 15:24:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2197', '2283', '901', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 15:24:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2198', '2284', '901', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 15:24:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2199', '2285', '901', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 15:24:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2200', '2286', '901', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 15:24:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2201', '2264', '896', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:07:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2202', '2261', '894', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:09:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2203', '2244', '886-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:38:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2204', '2245', '886-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:38:23');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2205', '2294', '904', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:40:55');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2206', '2241', '884-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:52:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2207', '2242', '884-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:52:20');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2208', '2258', '892', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:53:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2209', '2224', '874', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 16:55:51');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2210', '2243', '885', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 17:12:10');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2211', '2298', '908', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 17:52:13');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2212', '2299', '909', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 18:01:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2213', '2300', '909', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 18:01:37');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2214', '2301', '910', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 18:03:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2215', '2302', '910', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 18:03:44');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2216', '2262', '895', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 18:08:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2217', '2263', '895', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-10', '2', 'SI', '2024-06-10 18:08:21');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2218', '2303', '911', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-10 18:32:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2219', '2304', '911', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-06', '2', 'SI', '2024-06-10 18:32:26');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2220', '2310', '913', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 18:38:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2221', '2311', '913', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 18:38:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2222', '2312', '913', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 18:38:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2223', '2313', '913', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-10 18:38:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2224', '2305', '912', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 18:40:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2225', '2306', '912', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 18:40:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2226', '2307', '912', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 18:40:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2227', '2308', '912', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 18:40:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2228', '2309', '912', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-08', '2', 'SI', '2024-06-10 18:40:39');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2229', '2265', '897', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 08:47:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2230', '2266', '898', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 09:06:05');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2231', '2253', '890-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 10:08:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2232', '2254', '890-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 10:08:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2233', '2255', '890-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 10:08:03');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2234', '2256', '890-4', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 10:08:04');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2235', '2317', '916', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '1', 'SI', '2024-06-11 10:12:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2236', '2318', '916', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '1', 'SI', '2024-06-11 10:12:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2237', '2319', '916', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '1', 'SI', '2024-06-11 10:12:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2238', '2320', '916', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '1', 'SI', '2024-06-11 10:12:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2239', '2321', '916', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '1', 'SI', '2024-06-11 10:12:48');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2240', '2249', '889-1', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 10:14:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2241', '2250', '889-2', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 10:14:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2242', '2251', '889-3', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 10:14:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2243', '2252', '889-4', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 10:14:08');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2244', '2293', '903', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 11:05:46');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2245', '2259', '893', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 11:27:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2246', '2260', '893', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 11:27:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2247', '2326', '920', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 14:24:42');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2248', '2296', '906', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '1', 'SI', '2024-06-11 14:29:31');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2249', '2297', '907', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-11', '2', 'SI', '2024-06-11 14:46:59');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2250', '2335', '923', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-11 15:13:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2251', '2336', '923', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-11 15:13:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2252', '2337', '923', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-11 15:13:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2253', '2338', '923', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-11 15:13:45');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2254', '2331', '922', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-11 15:14:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2255', '2332', '922', 'MUESTRA CERRADA Y SELLADA CORRECTAMENTE', '2024-06-09', '2', 'SI', '2024-06-11 15:14:54');
INSERT INTO `despacho` (`despacho_id`, `id_recepcion`, `n_certificado`, `observacion`, `fecha_emision`, `id_usuario`, `estado_despacho`, `created_at`) VALUES ('2256', '2333', '922', 'M